/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto;

import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.crypto.Hash;
import org.fisco.bcos.web3j.crypto.RawTransaction;
import org.fisco.bcos.web3j.crypto.TransactionEncoder;
import org.fisco.bcos.web3j.utils.Numeric;

public class TransactionUtils {
    public static byte[] generateTransactionHash(RawTransaction rawTransaction, Credentials credentials) {
        byte[] signedMessage = TransactionEncoder.signMessage(rawTransaction, credentials);
        return Hash.sha3(signedMessage);
    }

    public static byte[] generateTransactionHash(RawTransaction rawTransaction, byte chainId, Credentials credentials) {
        byte[] signedMessage = TransactionEncoder.signMessage(rawTransaction, chainId, credentials);
        return Hash.sha3(signedMessage);
    }

    public static String generateTransactionHashHexEncoded(RawTransaction rawTransaction, Credentials credentials) {
        return Numeric.toHexString(TransactionUtils.generateTransactionHash(rawTransaction, credentials));
    }

    public static String generateTransactionHashHexEncoded(RawTransaction rawTransaction, byte chainId, Credentials credentials) {
        return Numeric.toHexString(TransactionUtils.generateTransactionHash(rawTransaction, chainId, credentials));
    }
}

