/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto;

import java.math.BigInteger;
import java.security.SignatureException;
import org.fisco.bcos.web3j.crypto.ExtendedRawTransaction;
import org.fisco.bcos.web3j.crypto.ExtendedTransactionEncoder;
import org.fisco.bcos.web3j.crypto.Keys;
import org.fisco.bcos.web3j.crypto.Sign;

public class SignedExtendedRawTransaction
extends ExtendedRawTransaction {
    private static final int CHAIN_ID_INC = 35;
    private static final int LOWER_REAL_V = 27;
    private Sign.SignatureData signatureData;

    public SignedExtendedRawTransaction(BigInteger randomid, BigInteger gasPrice, BigInteger gasLimit, BigInteger blockLimit, String to, BigInteger value, String data, BigInteger chainId, BigInteger groupId, String extraData, Sign.SignatureData signatureData) {
        super(randomid, gasPrice, gasLimit, blockLimit, to, value, data, chainId, groupId, extraData);
        this.signatureData = signatureData;
    }

    public Sign.SignatureData getSignatureData() {
        return this.signatureData;
    }

    public String getFrom() throws SignatureException {
        Integer chainId = this.getChainId();
        byte[] encodedTransaction = null == chainId ? ExtendedTransactionEncoder.encode(this) : ExtendedTransactionEncoder.encode((ExtendedRawTransaction)this, chainId.byteValue());
        byte v = this.signatureData.getV();
        byte[] r = this.signatureData.getR();
        byte[] s = this.signatureData.getS();
        Sign.SignatureData signatureDataV = new Sign.SignatureData(this.getRealV(v), r, s);
        BigInteger key = Sign.signedMessageToKey(encodedTransaction, signatureDataV);
        return "0x" + Keys.getAddress(key);
    }

    public void verify(String from) throws SignatureException {
        String actualFrom = this.getFrom();
        if (!actualFrom.equals(from)) {
            throw new SignatureException("from mismatch");
        }
    }

    private byte getRealV(byte v) {
        if (v == 27 || v == 28) {
            return v;
        }
        int realV = 27;
        int inc = 0;
        if (v % 2 == 0) {
            inc = 1;
        }
        return (byte)(realV + inc);
    }

    public Integer getChainId() {
        byte v = this.signatureData.getV();
        if (v == 27 || v == 28) {
            return null;
        }
        Integer chainId = (v - 35) / 2;
        return chainId;
    }
}

