/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECPoint;
import org.fisco.bcos.web3j.crypto.Sign;

public class ECDSASignature {
    public BigInteger r;
    public BigInteger s;
    public ECPoint p;

    public ECDSASignature(BigInteger r, BigInteger s, ECPoint p) {
        this.r = r;
        this.s = s;
        this.p = p;
    }

    public ECDSASignature(BigInteger r, BigInteger s) {
        this(r, s, null);
    }

    public boolean isCanonical() {
        return this.s.compareTo(Sign.HALF_CURVE_ORDER) <= 0;
    }

    public ECDSASignature toCanonicalised() {
        if (!this.isCanonical()) {
            return new ECDSASignature(this.r, Sign.CURVE.getN().subtract(this.s), this.p);
        }
        return this;
    }
}

