/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.ssl.SMSslClientContextFactory;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.fisco.bcos.channel.handler.ChannelHandler;
import org.fisco.bcos.channel.handler.ChannelHandlerContextHelper;
import org.fisco.bcos.channel.handler.ConnectionInfo;
import org.fisco.bcos.web3j.crypto.EncryptType;
import org.fisco.bcos.web3j.tuples.generated.Tuple2;
import org.fisco.bcos.web3j.tuples.generated.Tuple3;
import org.fisco.bcos.web3j.utils.Host;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ChannelConnections {
    private static Logger logger = LoggerFactory.getLogger(ChannelConnections.class);
    private Callback callback;
    private List<String> connectionsStr;
    private static final String CA_CERT = "classpath:ca.crt";
    private static final String SSL_CERT = "classpath:node.crt";
    private static final String SSL_KEY = "classpath:node.key";
    private Resource caCert;
    private Resource sslCert;
    private Resource sslKey;
    private Resource gmCaCert;
    private Resource gmSslCert;
    private Resource gmSslKey;
    private Resource gmEnSslCert;
    private Resource gmEnSslKey;
    private List<ConnectionInfo> connections = new ArrayList<ConnectionInfo>();
    private Boolean running = false;
    private ThreadPoolTaskExecutor threadPool;
    private long idleTimeout = 10000L;
    private long heartBeatDelay = 2000L;
    private long reconnectDelay = 20000L;
    private long connectTimeout = 10000L;
    private long sslHandShakeTimeout = 10000L;
    public Map<String, ChannelHandlerContext> networkConnections = new ConcurrentHashMap<String, ChannelHandlerContext>();
    private int groupId;
    private Bootstrap bootstrap = new Bootstrap();
    ServerBootstrap serverBootstrap = new ServerBootstrap();
    private ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1);

    public Resource getCaCert() {
        return this.caCert;
    }

    public void setCaCert(Resource caCert) {
        this.caCert = caCert;
    }

    public Resource getSslCert() {
        return this.sslCert;
    }

    public void setSslCert(Resource sslCert) {
        this.sslCert = sslCert;
    }

    public Resource getSslKey() {
        return this.sslKey;
    }

    public void setSslKey(Resource sslKey) {
        this.sslKey = sslKey;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public List<String> getConnectionsStr() {
        return this.connectionsStr;
    }

    public void setConnectionsStr(List<String> connectionsStr) {
        this.connectionsStr = connectionsStr;
    }

    public List<ConnectionInfo> getConnections() {
        return this.connections;
    }

    public void setConnections(List<ConnectionInfo> connections) {
        this.connections = connections;
    }

    public ThreadPoolTaskExecutor getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ThreadPoolTaskExecutor threadPool) {
        this.threadPool = threadPool;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public long getHeartBeatDelay() {
        return this.heartBeatDelay;
    }

    public void setHeartBeatDelay(long heartBeatDelay) {
        this.heartBeatDelay = heartBeatDelay;
    }

    public ChannelHandlerContext randomNetworkConnection(ConcurrentHashMap<String, BigInteger> nodeToBlockNumberMap) throws Exception {
        ArrayList<ChannelHandlerContext> activeConnections = new ArrayList<ChannelHandlerContext>();
        for (ChannelHandlerContext ctx : this.networkConnections.values()) {
            if (!Objects.nonNull(ctx) || !ChannelHandlerContextHelper.isChannelAvailable(ctx)) continue;
            activeConnections.add(ctx);
        }
        if (activeConnections.isEmpty()) {
            logger.error(" no active connection is available, maybe network connection exception");
            throw new Exception(" no active connection available network exception");
        }
        ArrayList<ChannelHandlerContext> maxBlockNumberConnections = new ArrayList<ChannelHandlerContext>();
        BigInteger maxBlockNumber = new BigInteger("0");
        if (nodeToBlockNumberMap != null) {
            for (String key : nodeToBlockNumberMap.keySet()) {
                Optional<ChannelHandlerContext> optionalCtx;
                BigInteger blockNumber = nodeToBlockNumberMap.get(key);
                if (blockNumber.compareTo(maxBlockNumber) < 0) continue;
                if (blockNumber.compareTo(maxBlockNumber) > 0) {
                    maxBlockNumberConnections.clear();
                }
                if (!(optionalCtx = activeConnections.stream().filter(x -> key.equals(((SocketChannel)x.channel()).remoteAddress().getAddress().getHostAddress() + ((SocketChannel)x.channel()).remoteAddress().getPort())).findFirst()).isPresent()) continue;
                ChannelHandlerContext channelHandlerContext = optionalCtx.get();
                maxBlockNumberConnections.add(channelHandlerContext);
                maxBlockNumber = blockNumber;
            }
        }
        SecureRandom random = new SecureRandom();
        int selectNodeIndex = 0;
        ChannelHandlerContext selectedNodeChannelHandlerContext = null;
        if (!maxBlockNumberConnections.isEmpty()) {
            selectNodeIndex = random.nextInt(maxBlockNumberConnections.size());
            selectedNodeChannelHandlerContext = (ChannelHandlerContext)maxBlockNumberConnections.get(selectNodeIndex);
        } else {
            selectNodeIndex = random.nextInt(activeConnections.size());
            selectedNodeChannelHandlerContext = (ChannelHandlerContext)activeConnections.get(selectNodeIndex);
        }
        return selectedNodeChannelHandlerContext;
    }

    public Map<String, ChannelHandlerContext> getNetworkConnections() {
        return this.networkConnections;
    }

    public ChannelHandlerContext getNetworkConnectionByHost(String host, Integer port) {
        String endpoint = host + ":" + port;
        return this.networkConnections.get(endpoint);
    }

    public ChannelHandlerContext setAndGetNetworkConnectionByHost(String host, Integer port, ChannelHandlerContext ctx) {
        String endpoint = host + ":" + port;
        return this.networkConnections.put(endpoint, ctx);
    }

    public void removeNetworkConnectionByHost(String host, Integer port, ChannelHandlerContext ctx) {
        String endpoint = host + ":" + port;
        Boolean result = this.networkConnections.remove(endpoint, ctx);
        if (logger.isDebugEnabled()) {
            logger.debug(" result: {}, host: {}, port: {}, ctx: {}", new Object[]{result, host, port, System.identityHashCode(ctx)});
        }
    }

    public void init() {
        logger.debug("init connections");
        if (Objects.isNull(this.connectionsStr) || this.connectionsStr.isEmpty()) {
            throw new IllegalArgumentException(" Invalid configuration, the number of connected nodes is empty, please check \"connectionsStr\" field.");
        }
        for (String connectionStr : this.connectionsStr) {
            ConnectionInfo connection = new ConnectionInfo();
            String[] stringArray = connectionStr.split(":");
            if (stringArray.length < 1) {
                throw new IllegalArgumentException(" Invalid configuration, the value should in IP:Port format(eg: 127.0.0.1:1111), value: " + connectionStr);
            }
            String IP = stringArray[0];
            String port = stringArray[1];
            if (!Host.validIP(IP)) {
                throw new IllegalArgumentException(" Invalid configuration, invalid IP string format, value: " + IP);
            }
            if (!Host.validPort(port)) {
                throw new IllegalArgumentException(" Invalid configuration, tcp port should from 1 to 65535, value: " + port);
            }
            connection.setHost(IP);
            connection.setPort(Integer.parseInt(port));
            this.connections.add(connection);
        }
        logger.info(" all connections: {}", this.connections);
    }

    public void startConnect() throws Exception {
        SslContext sslContext;
        if (this.running.booleanValue()) {
            logger.debug("running");
            return;
        }
        logger.debug(" start connect. ");
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        this.bootstrap.group((EventLoopGroup)workerGroup);
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)this.connectTimeout));
        final ChannelConnections selfService = this;
        final ThreadPoolTaskExecutor selfThreadPool = this.threadPool;
        final SslContext finalSslContext = sslContext = EncryptType.encryptType == 0 ? this.initSslContext() : this.initSMSslContext();
        this.bootstrap.handler((io.netty.channel.ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelHandler handler = new ChannelHandler();
                handler.setConnections(selfService);
                handler.setThreadPool(selfThreadPool);
                SslHandler sslHandler = finalSslContext.newHandler(ch.alloc());
                sslHandler.setHandshakeTimeoutMillis(ChannelConnections.this.sslHandShakeTimeout);
                ch.pipeline().addLast(new io.netty.channel.ChannelHandler[]{sslHandler, new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 0), new IdleStateHandler(ChannelConnections.this.idleTimeout, ChannelConnections.this.idleTimeout, ChannelConnections.this.idleTimeout, TimeUnit.MILLISECONDS), handler});
            }
        });
        ArrayList<Tuple3<String, Integer, ChannelFuture>> tuple3List = new ArrayList<Tuple3<String, Integer, ChannelFuture>>();
        for (ConnectionInfo connectionInfo : this.connections) {
            String IP = connectionInfo.getHost();
            Integer n = connectionInfo.getPort();
            ChannelFuture channelFuture = this.bootstrap.connect(IP, n.intValue());
            tuple3List.add(new Tuple3<String, Integer, ChannelFuture>(IP, n, channelFuture));
        }
        boolean atLeastOneConnectSuccess = false;
        ArrayList<String> errorMessageList = new ArrayList<String>();
        for (Tuple3 tuple3 : tuple3List) {
            ChannelFuture connectFuture = ((ChannelFuture)tuple3.getValue3()).awaitUninterruptibly();
            if (!connectFuture.isSuccess()) {
                logger.error(" connect to {}:{}, error: {}", new Object[]{tuple3.getValue1(), tuple3.getValue2(), connectFuture.cause().getMessage()});
                String connectFailedMessage = Objects.isNull(connectFuture.cause()) ? "connect to " + (String)tuple3.getValue1() + ":" + tuple3.getValue2() + " failed" : connectFuture.cause().getMessage();
                errorMessageList.add(connectFailedMessage);
                continue;
            }
            logger.trace(" connect to {}:{} success", tuple3.getValue1(), tuple3.getValue2());
            SslHandler sslhandler = (SslHandler)connectFuture.channel().pipeline().get(SslHandler.class);
            if (Objects.isNull(sslhandler)) {
                String sslHandshakeFailedMessage = " ssl handshake failed:/" + (String)tuple3.getValue1() + ":" + tuple3.getValue2();
                logger.debug(" SslHandler is null, host: {}, port: {}", tuple3.getValue1(), tuple3.getValue2());
                errorMessageList.add(sslHandshakeFailedMessage);
                continue;
            }
            Future sshHandshakeFuture = sslhandler.handshakeFuture().awaitUninterruptibly();
            if (sshHandshakeFuture.isSuccess()) {
                atLeastOneConnectSuccess = true;
                logger.trace(" ssl handshake success {}:{}", tuple3.getValue1(), tuple3.getValue2());
                continue;
            }
            String sslHandshakeFailedMessage = " ssl handshake failed:/" + (String)tuple3.getValue1() + ":" + tuple3.getValue2();
            errorMessageList.add(sslHandshakeFailedMessage);
        }
        if (!atLeastOneConnectSuccess) {
            logger.error(" all connections have failed, " + ((Object)errorMessageList).toString());
            throw new RuntimeException(" Failed to connect to nodes: " + ((Object)errorMessageList).toString());
        }
        this.running = true;
        logger.debug(" start connect end. ");
    }

    public void startPeriodTask() {
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.heartbeat(), 0L, this.heartBeatDelay, TimeUnit.MILLISECONDS);
        this.scheduledExecutorService.scheduleAtFixedRate(() -> this.reconnect(), 0L, this.reconnectDelay, TimeUnit.MILLISECONDS);
    }

    public SslContext initSMSslContext() throws IOException, InvalidKeySpecException, CertificateException, NoSuchAlgorithmException, NoSuchProviderException {
        if (this.getGmCaCert() != null && this.getGmCaCert().exists() || this.getGmEnSslCert() != null && this.getGmEnSslCert().exists() || this.getGmEnSslKey() != null && this.getGmEnSslKey().exists() || this.getGmSslCert() != null && this.getGmSslCert().exists() || this.getGmSslKey() != null && this.getGmSslKey().exists()) {
            return SMSslClientContextFactory.build((InputStream)this.getGmCaCert().getInputStream(), (InputStream)this.getGmEnSslCert().getInputStream(), (InputStream)this.getGmEnSslKey().getInputStream(), (InputStream)this.getGmSslCert().getInputStream(), (InputStream)this.getGmSslKey().getInputStream());
        }
        logger.info(" Has no SM Ssl certificate configuration ");
        return this.initSslContext();
    }

    private SslContext initSslContext() throws SSLException {
        SslContext sslCtx;
        try {
            Resource resource;
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            Resource caResource = this.getCaCert();
            Resource keystorecaResource = this.getSslCert();
            Resource keystorekeyResource = this.getSslKey();
            if (Objects.isNull(caResource) || !caResource.exists()) {
                throw new RuntimeException((Objects.nonNull(caResource) ? "ca.crt" : caResource.getFilename()) + " not exist ");
            }
            if (Objects.isNull(keystorecaResource) || !keystorecaResource.exists()) {
                resource = resolver.getResource(SSL_CERT);
                if (Objects.nonNull(resource) && resource.exists()) {
                    keystorecaResource = resource;
                } else {
                    throw new RuntimeException((Objects.nonNull(keystorecaResource) ? "sdk.crt" : keystorecaResource.getFilename()) + " not exist ");
                }
            }
            if (Objects.isNull(keystorekeyResource) || !keystorekeyResource.exists()) {
                resource = resolver.getResource(SSL_KEY);
                if (Objects.nonNull(resource) && resource.exists()) {
                    keystorekeyResource = resource;
                } else {
                    throw new RuntimeException((Objects.nonNull(keystorekeyResource) ? "sdk.key" : keystorekeyResource.getFilename()) + " not exist ");
                }
            }
            logger.info(" ca certificate: {}, sdk certificate: {}, sdk key: {}", new Object[]{caResource.getFilename(), keystorecaResource.getFilename(), keystorekeyResource.getFilename()});
            sslCtx = SslContextBuilder.forClient().trustManager(caResource.getInputStream()).keyManager(keystorecaResource.getInputStream(), keystorekeyResource.getInputStream()).sslProvider(SslProvider.JDK).build();
        }
        catch (Exception e) {
            logger.error(" Failed to initialize the SSLContext, e: {} ", e.getCause());
            throw new SSLException(" Failed to initialize the SSLContext: " + e.getMessage());
        }
        return sslCtx;
    }

    public void heartbeat() {
        ArrayList<Tuple2<String, ChannelHandlerContext>> tuple2List = new ArrayList<Tuple2<String, ChannelHandlerContext>>();
        for (ConnectionInfo connectionInfo : this.connections) {
            String peer = connectionInfo.getHost() + ":" + connectionInfo.getPort();
            ChannelHandlerContext ctx = this.networkConnections.get(peer);
            if (!Objects.nonNull(ctx) || !ctx.channel().isActive() || !ChannelHandlerContextHelper.isChannelAvailable(ctx)) continue;
            tuple2List.add(new Tuple2<String, ChannelHandlerContext>(peer, ctx));
        }
        for (Tuple2 tuple2 : tuple2List) {
            logger.trace(" send heart beat to {}", tuple2.getValue1());
            this.callback.sendHeartbeat((ChannelHandlerContext)tuple2.getValue2());
        }
    }

    public void reconnect() {
        ArrayList<ConnectionInfo> connectionInfoList = new ArrayList<ConnectionInfo>();
        int aliveConnectionCount = 0;
        for (ConnectionInfo connectionInfo : this.connections) {
            String peer = connectionInfo.getHost() + ":" + connectionInfo.getPort();
            ChannelHandlerContext ctx = this.networkConnections.get(peer);
            if (Objects.isNull(ctx) || !ctx.channel().isActive()) {
                connectionInfoList.add(connectionInfo);
                continue;
            }
            ++aliveConnectionCount;
        }
        logger.trace(" Keep alive nodes count: {}", (Object)aliveConnectionCount);
        for (ConnectionInfo connectionInfo : connectionInfoList) {
            logger.debug(" try reconnect to {}:{}", (Object)connectionInfo.getHost(), (Object)connectionInfo.getPort());
            this.bootstrap.connect(connectionInfo.getHost(), connectionInfo.getPort().intValue()).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    logger.trace(" reconnect to {}:{} success", (Object)connectionInfo.getHost(), (Object)connectionInfo.getPort());
                } else {
                    logger.error(" reconnect to {}:{}, error: {}", new Object[]{connectionInfo.getHost(), connectionInfo.getPort(), future.cause().getMessage()});
                }
            }));
        }
    }

    public void onReceiveMessage(ChannelHandlerContext ctx, ByteBuf message) {
        this.callback.onMessage(ctx, message);
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getSslHandShakeTimeout() {
        return this.sslHandShakeTimeout;
    }

    public void setSslHandShakeTimeout(long sslHandShakeTimeout) {
        this.sslHandShakeTimeout = sslHandShakeTimeout;
    }

    public Resource getGmCaCert() {
        return this.gmCaCert;
    }

    public void setGmCaCert(Resource gmCaCert) {
        this.gmCaCert = gmCaCert;
    }

    public Resource getGmSslCert() {
        return this.gmSslCert;
    }

    public void setGmSslCert(Resource gmSslCert) {
        this.gmSslCert = gmSslCert;
    }

    public Resource getGmSslKey() {
        return this.gmSslKey;
    }

    public void setGmSslKey(Resource gmSslKey) {
        this.gmSslKey = gmSslKey;
    }

    public Resource getGmEnSslCert() {
        return this.gmEnSslCert;
    }

    public void setGmEnSslCert(Resource gmEnSslCert) {
        this.gmEnSslCert = gmEnSslCert;
    }

    public Resource getGmEnSslKey() {
        return this.gmEnSslKey;
    }

    public void setGmEnSslKey(Resource gmEnSslKey) {
        this.gmEnSslKey = gmEnSslKey;
    }

    public static interface Callback {
        public void onConnect(ChannelHandlerContext var1);

        public void onDisconnect(ChannelHandlerContext var1);

        public void onMessage(ChannelHandlerContext var1, ByteBuf var2);

        public void sendHeartbeat(ChannelHandlerContext var1);
    }
}

