/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.event.filter;

import io.netty.channel.ChannelHandlerContext;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.channel.event.filter.EventLogFilterStatus;
import org.fisco.bcos.channel.event.filter.EventLogPushCallback;
import org.fisco.bcos.channel.event.filter.EventLogUserParams;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.tx.txdecode.LogResult;

public class EventLogFilter {
    private String registerID;
    private String filterID;
    private EventLogUserParams params;
    private EventLogPushCallback callback;
    private EventLogFilterStatus status = EventLogFilterStatus.WAITING_RESPONSE;
    private ChannelHandlerContext ctx = null;
    private BigInteger lastBlockNumber = null;
    private long logCount = 0L;

    public EventLogPushCallback getCallback() {
        return this.callback;
    }

    public void setCallback(EventLogPushCallback callback) {
        this.callback = callback;
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public EventLogUserParams getParams() {
        return this.params;
    }

    public void setParams(EventLogUserParams params) {
        this.params = params;
    }

    public EventLogFilterStatus getStatus() {
        return this.status;
    }

    public void setStatus(EventLogFilterStatus status) {
        this.status = status;
    }

    public String getRegisterID() {
        return this.registerID;
    }

    public void setRegisterID(String registerID) {
        this.registerID = registerID;
    }

    public BigInteger getLastBlockNumber() {
        return this.lastBlockNumber;
    }

    public void setLastBlockNumber(BigInteger lastBlockNumber) {
        this.lastBlockNumber = lastBlockNumber;
    }

    public long getLogCount() {
        return this.logCount;
    }

    public void setLogCount(long logCount) {
        this.logCount = logCount;
    }

    public void addLogCount(int i) {
        this.logCount += (long)i;
    }

    public String getFilterID() {
        return this.filterID;
    }

    public void setFilterID(String filterID) {
        this.filterID = filterID;
    }

    public String toString() {
        return "EventLogFilter [registerID=" + this.registerID + ", filterID=" + this.filterID + ", params=" + this.params + ", status=" + (Object)((Object)this.status) + ", ctx=" + this.ctx + ", lastBlockNumber=" + this.lastBlockNumber + ", logCount=" + this.logCount + "]";
    }

    public EventLogUserParams generateNewParams() {
        EventLogUserParams params = new EventLogUserParams();
        params.setToBlock(this.getParams().getToBlock());
        params.setAddresses(this.getParams().getAddresses());
        params.setTopics(this.getParams().getTopics());
        if (this.lastBlockNumber == null) {
            params.setFromBlock(this.getParams().getFromBlock());
        } else {
            params.setFromBlock(this.lastBlockNumber.toString());
        }
        return params;
    }

    public void updateByLogResult(List<LogResult> logResults) {
        if (logResults.isEmpty()) {
            return;
        }
        Log lastLog = logResults.get(logResults.size() - 1).getLog();
        if (this.lastBlockNumber == null) {
            this.lastBlockNumber = lastLog.getBlockNumber();
            this.logCount += (long)logResults.size();
        } else if (lastLog.getBlockNumber().compareTo(this.lastBlockNumber) > 0) {
            this.lastBlockNumber = lastLog.getBlockNumber();
            this.logCount += (long)logResults.size();
        }
    }
}

