/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collections;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.fisco.bcos.web3j.crypto.ECKeyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class PEMManager {
    private static final Logger logger = LoggerFactory.getLogger(PEMManager.class);
    private PemObject pem;
    private String pemFile;

    public PEMManager() {
        Security.setProperty("crypto.policy", "unlimited");
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void load() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, NoSuchProviderException, InvalidKeySpecException {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource pemResources = resolver.getResource(this.pemFile);
        this.load(pemResources.getInputStream());
    }

    public void load(InputStream in) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, InvalidKeySpecException, NoSuchProviderException {
        PemReader pemReader = new PemReader((Reader)new InputStreamReader(in));
        this.pem = pemReader.readPemObject();
        if (this.pem == null) {
            throw new IOException("The file does not represent a pem account.");
        }
        pemReader.close();
    }

    public PrivateKey getPrivateKey() throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(this.pem.getContent());
        KeyFactory keyFacotry = KeyFactory.getInstance("EC", "BC");
        return keyFacotry.generatePrivate(encodedKeySpec);
    }

    public PublicKey getPublicKeyFromPublicPem() throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(this.pem.getContent());
        KeyFactory keyFacotry = KeyFactory.getInstance("EC", "BC");
        return keyFacotry.generatePublic(encodedKeySpec);
    }

    public PublicKey getPublicKey() throws InvalidKeySpecException, NoSuchAlgorithmException, NoSuchProviderException {
        ECPrivateKey privateKey = (ECPrivateKey)this.getPrivateKey();
        ECParameterSpec params = privateKey.getParams();
        org.bouncycastle.jce.spec.ECParameterSpec bcSpec = EC5Util.convertSpec((ECParameterSpec)params, (boolean)false);
        org.bouncycastle.math.ec.ECPoint q = bcSpec.getG().multiply(privateKey.getS());
        org.bouncycastle.math.ec.ECPoint bcW = bcSpec.getCurve().decodePoint(q.getEncoded(false));
        ECPoint w = new ECPoint(bcW.getAffineXCoord().toBigInteger(), bcW.getAffineYCoord().toBigInteger());
        ECPublicKeySpec keySpec = new ECPublicKeySpec(w, PEMManager.tryFindNamedCurveSpec(params));
        return KeyFactory.getInstance("EC", "BC").generatePublic(keySpec);
    }

    public ECKeyPair getECKeyPair() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        PrivateKey privateKey = this.getPrivateKey();
        PublicKey publicKey = this.getPublicKey();
        KeyPair keyPair = new KeyPair(publicKey, privateKey);
        return ECKeyPair.create(keyPair);
    }

    public static ECParameterSpec tryFindNamedCurveSpec(ECParameterSpec params) {
        org.bouncycastle.jce.spec.ECParameterSpec bcSpec = EC5Util.convertSpec((ECParameterSpec)params, (boolean)false);
        for (Object name : Collections.list(ECNamedCurveTable.getNames())) {
            ECNamedCurveParameterSpec bcNamedSpec = ECNamedCurveTable.getParameterSpec((String)((String)name));
            if (!bcNamedSpec.getN().equals(bcSpec.getN()) || !bcNamedSpec.getH().equals(bcSpec.getH()) || !bcNamedSpec.getCurve().equals(bcSpec.getCurve()) || !bcNamedSpec.getG().equals(bcSpec.getG())) continue;
            return new ECNamedCurveSpec(bcNamedSpec.getName(), bcNamedSpec.getCurve(), bcNamedSpec.getG(), bcNamedSpec.getN(), bcNamedSpec.getH(), bcNamedSpec.getSeed());
        }
        return params;
    }

    public String getPemFile() {
        return this.pemFile;
    }

    public void setPemFile(String pemFile) {
        this.pemFile = pemFile;
    }
}

