/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslEngineMap;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.PemEncoded;
import io.netty.handler.ssl.PemPrivateKey;
import io.netty.handler.ssl.PemX509Certificate;
import io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SMTrustManager;
import io.netty.internal.tcnative.CertificateVerifier;
import io.netty.internal.tcnative.SSLContext;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public class SMSslClientContext
extends OpenSslContext {
    private final OpenSslSessionContext sessionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SMSslClientContext(X509Certificate[] trustCerts, X509Certificate[] encryptNodeCerts, PrivateKey encryptNodeKey, X509Certificate[] nodeCerts, PrivateKey nodeKey) throws SSLException {
        super(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, (ApplicationProtocolConfig)null, 0, null, ClientAuth.REQUIRE, null, false, false, new Map.Entry[0]);
        boolean success = false;
        try {
            this.sessionContext = SMSslClientContext.newSessionContext((ReferenceCountedOpenSslContext)this, this.ctx, this.engineMap, trustCerts, encryptNodeCerts, encryptNodeKey, nodeCerts, nodeKey);
            success = true;
        }
        finally {
            if (!success) {
                this.release();
            }
        }
    }

    public OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    static void setKeyMaterial(long ctx, X509Certificate[] enNodeCert, PrivateKey enNodeKey, X509Certificate[] nodeCert, PrivateKey nodeKey) throws SSLException {
        long enNodeKeyBio = 0L;
        long nodeKeyBio = 0L;
        long enNodeCertBio = 0L;
        long nodeCertBio = 0L;
        PemEncoded encoded = null;
        try {
            ByteBufAllocator allocator = ByteBufAllocator.DEFAULT;
            encoded = PemX509Certificate.toPEM((ByteBufAllocator)allocator, (boolean)true, (X509Certificate[])enNodeCert);
            enNodeCertBio = SMSslClientContext.toBIO((ByteBufAllocator)allocator, (PemEncoded)encoded.retain());
            encoded.release();
            encoded = PemX509Certificate.toPEM((ByteBufAllocator)allocator, (boolean)true, (X509Certificate[])nodeCert);
            nodeCertBio = SMSslClientContext.toBIO((ByteBufAllocator)allocator, (PemEncoded)encoded.retain());
            encoded.release();
            encoded = PemPrivateKey.toPEM((ByteBufAllocator)allocator, (boolean)true, (PrivateKey)enNodeKey);
            enNodeKeyBio = SMSslClientContext.toBIO((ByteBufAllocator)allocator, (PemEncoded)encoded.retain());
            encoded.release();
            encoded = PemPrivateKey.toPEM((ByteBufAllocator)allocator, (boolean)true, (PrivateKey)nodeKey);
            nodeKeyBio = SMSslClientContext.toBIO((ByteBufAllocator)allocator, (PemEncoded)encoded.retain());
            encoded.release();
            SSLContext.setCipherSuite((long)ctx, (String)"ALL", (boolean)false);
            SSLContext.setCertificateExtBio((long)ctx, (long)enNodeCertBio, (long)enNodeKeyBio, (long)nodeCertBio, (long)nodeKeyBio, (String)"");
        }
        catch (SSLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SSLException("failed to set certificate and key", e);
        }
        finally {
            SMSslClientContext.freeBio((long)enNodeKeyBio);
            SMSslClientContext.freeBio((long)nodeKeyBio);
            SMSslClientContext.freeBio((long)enNodeCertBio);
            SMSslClientContext.freeBio((long)nodeCertBio);
            if (encoded != null && encoded.refCnt() > 0) {
                encoded.release();
            }
        }
    }

    static OpenSslSessionContext newSessionContext(ReferenceCountedOpenSslContext context, long ctx, OpenSslEngineMap engineMap, X509Certificate[] trustCerts, X509Certificate[] encryptNodeCerts, PrivateKey enNodeKey, X509Certificate[] nodeCerts, PrivateKey nodeKey) throws SSLException {
        try {
            SMSslClientContext.setKeyMaterial(ctx, encryptNodeCerts, enNodeKey, nodeCerts, nodeKey);
        }
        catch (Exception e) {
            throw new SSLException("failed to set certificate and key", e);
        }
        SSLContext.setVerify((long)ctx, (int)0, (int)10);
        try {
            SMTrustManager manager = new SMTrustManager(trustCerts);
            if (SMSslClientContext.useExtendedTrustManager((X509TrustManager)manager)) {
                SSLContext.setCertVerifyCallback((long)ctx, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(engineMap, (X509ExtendedTrustManager)((Object)manager)));
            } else {
                SSLContext.setCertVerifyCallback((long)ctx, (CertificateVerifier)new TrustManagerVerifyCallback(engineMap, manager));
            }
        }
        catch (Exception e) {
            throw new SSLException("unable to setup TrustManager", e);
        }
        return new ReferenceCountedOpenSslClientContext.OpenSslClientSessionContext(context, null);
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(OpenSslEngineMap engineMap, X509ExtendedTrustManager manager) {
            super(engineMap);
            this.manager = manager;
        }

        void verify(ReferenceCountedOpenSslEngine engine, X509Certificate[] peerCerts, String auth) throws Exception {
            this.manager.checkServerTrusted(peerCerts, auth, (SSLEngine)engine);
        }
    }

    private static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(OpenSslEngineMap engineMap, X509TrustManager manager) {
            super(engineMap);
            this.manager = manager;
        }

        void verify(ReferenceCountedOpenSslEngine engine, X509Certificate[] peerCerts, String auth) throws Exception {
            this.manager.checkServerTrusted(peerCerts, auth);
        }
    }
}

