/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolService {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolService.class);
    public static Integer DEFAULT_KEEP_ALIVE_TIME = 60;
    private final ExecutorService threadPool;

    public ThreadPoolService(String threadName, Integer maxBlockingQueueSize) {
        this(threadName, Runtime.getRuntime().availableProcessors(), maxBlockingQueueSize);
    }

    public ThreadPoolService(String threadName, Integer corePoolSize, Integer maxBlockingQueueSize) {
        this(threadName, corePoolSize, corePoolSize, DEFAULT_KEEP_ALIVE_TIME, maxBlockingQueueSize);
        logger.debug("Create ThreadPoolService, threadName: {}, corePoolSize: {}, maxBlockingQueueSize: {}", new Object[]{threadName, corePoolSize, maxBlockingQueueSize});
    }

    public ThreadPoolService(String threadName, Integer corePoolSize, Integer maximumPoolSize, Integer keepAliveTime, Integer maxBlockingQueueSize) {
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(threadName).build();
        this.threadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime.intValue(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxBlockingQueueSize), (ThreadFactory)threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void stop() {
        ThreadPoolService.stopThreadPool(this.threadPool);
    }

    public static void stopThreadPool(ExecutorService threadPool) {
        threadPool.shutdown();
        try {
            while (!threadPool.isTerminated()) {
                threadPool.awaitTermination(10L, TimeUnit.MILLISECONDS);
            }
            threadPool.shutdownNow();
        }
        catch (InterruptedException ex) {
            threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

