/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.tools;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.fisco.bcos.sdk.abi.tools.ContractAbiUtil;
import org.fisco.bcos.sdk.abi.wrapper.ABIDefinition;
import org.fisco.bcos.sdk.transaction.model.bo.AbiInfo;
import org.fisco.bcos.sdk.transaction.model.bo.BinInfo;
import org.fisco.bcos.sdk.transaction.model.exception.NoSuchTransactionFileException;
import org.fisco.bcos.sdk.transaction.model.exception.TransactionRetCodeConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractLoader {
    private static final Logger log = LoggerFactory.getLogger(ContractLoader.class);
    private Map<String, List<ABIDefinition>> contractFuncAbis = new HashMap<String, List<ABIDefinition>>();
    private Map<String, ABIDefinition> contractConstructorAbi = new HashMap<String, ABIDefinition>();
    private Map<String, String> contractBinMap = new HashMap<String, String>();
    private Map<String, String> contractAbiMap = new HashMap<String, String>();

    public ContractLoader(String abiFilePath, String binaryFilePath) throws Exception {
        this.binInfo(binaryFilePath);
        this.abiInfo(abiFilePath);
    }

    public ContractLoader(String contractName, String abi, String bin) {
        this.loadBinary(contractName, bin);
        this.loadABI(contractName, abi);
    }

    public boolean appendContractAbi(String contractName, String abi) {
        return this.loadABI(contractName, abi);
    }

    public boolean appendContractBinary(String contractName, String bin) {
        return this.loadBinary(contractName, bin);
    }

    protected boolean loadBinary(String contractName, String bin) {
        if (this.contractAbiMap.get(contractName) != null) {
            log.warn("loadBinary failed for the binary information of {} already exists", (Object)contractName);
            return false;
        }
        if (bin == null || StringUtils.isEmpty((CharSequence)bin)) {
            log.warn("ContractLoader: Empty bin directory, cannot deploy any contract");
            return false;
        }
        this.contractBinMap.put(contractName, bin);
        return true;
    }

    protected boolean loadABI(String contractName, String abi) {
        if (this.contractAbiMap.get(contractName) != null) {
            log.warn("loadABI failed for the abi information of {} already exists", (Object)contractName);
            return false;
        }
        List<ABIDefinition> abiDefinitionList = ContractAbiUtil.getFuncABIDefinition(abi);
        this.contractFuncAbis.put(contractName, abiDefinitionList);
        ABIDefinition constructorAbi = ContractLoader.selectConstructor(abiDefinitionList);
        this.contractConstructorAbi.put(contractName, constructorAbi);
        this.contractAbiMap.put(contractName, abi);
        return true;
    }

    public BinInfo binInfo(String binaryFilePath) throws IOException {
        if (StringUtils.isEmpty((CharSequence)binaryFilePath)) {
            log.warn("Empty bin directory, cannot deploy any contract");
            return new BinInfo(Collections.emptyMap());
        }
        String[] s = new String[]{"bin"};
        Collection fileCollection = FileUtils.listFiles((File)new File(binaryFilePath), (String[])s, (boolean)false);
        if (fileCollection.isEmpty()) {
            log.warn("No bin found, cannot deploy any contract");
            return new BinInfo(Collections.emptyMap());
        }
        this.contractBinMap = new HashMap<String, String>();
        for (File file : fileCollection) {
            String contract = this.parseContractName(file);
            String bin = FileUtils.readFileToString((File)file);
            this.loadBinary(contract, bin);
        }
        return new BinInfo(this.contractBinMap);
    }

    public AbiInfo abiInfo(String abiFilePath) throws Exception {
        String[] s = new String[]{"abi"};
        Collection fileCollection = FileUtils.listFiles((File)new File(abiFilePath), (String[])s, (boolean)false);
        for (File file : fileCollection) {
            String contract = this.parseContractName(file);
            String abi = FileUtils.readFileToString((File)file);
            this.loadABI(contract, abi);
        }
        return new AbiInfo(this.contractFuncAbis, this.contractConstructorAbi);
    }

    public static ABIDefinition selectConstructor(List<ABIDefinition> abiList) {
        for (ABIDefinition ABIDefinition2 : abiList) {
            if (!ABIDefinition2.getType().equals("constructor")) continue;
            return ABIDefinition2;
        }
        return null;
    }

    private String parseContractName(File file) {
        String fileName = file.getName();
        return StringUtils.substringBefore((String)fileName, (String)".");
    }

    private List<ABIDefinition> parseAbiBody(File file) throws Exception {
        String abiStr = FileUtils.readFileToString((File)file);
        return ContractAbiUtil.getFuncABIDefinition(abiStr);
    }

    public String getABIByContractName(String contractName) throws NoSuchTransactionFileException {
        if (this.contractAbiMap.get(contractName) == null) {
            log.error("Contract {} not found.", (Object)contractName);
            throw new NoSuchTransactionFileException(TransactionRetCodeConstants.NO_SUCH_ABI_FILE);
        }
        return this.contractAbiMap.get(contractName);
    }

    public String getBinaryByContractName(String contractName) throws NoSuchTransactionFileException {
        if (this.contractBinMap.get(contractName) == null) {
            log.error("Contract {} not found.", (Object)contractName);
            throw new NoSuchTransactionFileException(TransactionRetCodeConstants.NO_SUCH_BINARY_FILE);
        }
        return this.contractBinMap.get(contractName);
    }

    public Pair<String, String> getABIAndBinaryByContractName(String contractName) throws NoSuchTransactionFileException {
        if (this.contractAbiMap.get(contractName) == null) {
            log.error("Contract {} not found.", (Object)contractName);
            throw new NoSuchTransactionFileException(TransactionRetCodeConstants.NO_SUCH_ABI_FILE);
        }
        if (this.contractBinMap.get(contractName) == null) {
            log.error("Contract {} not found.", (Object)contractName);
            throw new NoSuchTransactionFileException(TransactionRetCodeConstants.NO_SUCH_BINARY_FILE);
        }
        return Pair.of((Object)this.contractAbiMap.get(contractName), (Object)this.contractBinMap.get(contractName));
    }

    public ABIDefinition getConstructorABIByContractName(String contractName) throws NoSuchTransactionFileException {
        return ContractLoader.selectConstructor(this.getFunctionABIListByContractName(contractName));
    }

    public List<ABIDefinition> getFunctionABIListByContractName(String contractName) throws NoSuchTransactionFileException {
        if (this.contractFuncAbis.get(contractName) == null) {
            log.error("Contract {} not found.", (Object)contractName);
            throw new NoSuchTransactionFileException(TransactionRetCodeConstants.NO_SUCH_ABI_FILE);
        }
        return this.contractFuncAbis.get(contractName);
    }
}

