/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.pusher;

import java.util.concurrent.CompletableFuture;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.client.protocol.request.Transaction;
import org.fisco.bcos.sdk.client.protocol.response.Call;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.transaction.pusher.TransactionPusherInterface;

public class TransactionPusherService
implements TransactionPusherInterface {
    private Client client;

    public TransactionPusherService(Client client) {
        this.client = client;
    }

    @Override
    public void pushOnly(String signedTransaction) {
        this.client.sendRawTransactionAndGetReceiptAsync(signedTransaction, null);
    }

    @Override
    public Call push(String from, String to, String encodedFunction) {
        Transaction transaction = new Transaction(from, to, encodedFunction);
        return this.client.call(transaction);
    }

    @Override
    public TransactionReceipt push(String signedTransaction) {
        return this.client.sendRawTransactionAndGetReceipt(signedTransaction);
    }

    @Override
    public void pushAsync(String signedTransactionData, TransactionCallback callback) {
        this.client.sendRawTransactionAndGetReceiptAsync(signedTransactionData, callback);
    }

    @Override
    public CompletableFuture<TransactionReceipt> pushAsync(String signedTransaction) {
        CompletableFuture<TransactionReceipt> future = CompletableFuture.supplyAsync(() -> this.push(signedTransaction));
        return future;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

