/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.manager;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bouncycastle.util.encoders.Hex;
import org.fisco.bcos.sdk.abi.ABICodecException;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.transaction.codec.encode.TransactionEncoderService;
import org.fisco.bcos.sdk.transaction.manager.AssembleTransactionProcessor;
import org.fisco.bcos.sdk.transaction.manager.AssembleTransactionWithRemoteSignProviderInterface;
import org.fisco.bcos.sdk.transaction.model.dto.TransactionResponse;
import org.fisco.bcos.sdk.transaction.model.exception.NoSuchTransactionFileException;
import org.fisco.bcos.sdk.transaction.model.exception.TransactionBaseException;
import org.fisco.bcos.sdk.transaction.model.po.RawTransaction;
import org.fisco.bcos.sdk.transaction.signer.RemoteSignCallbackInterface;
import org.fisco.bcos.sdk.transaction.signer.RemoteSignProviderInterface;
import org.fisco.bcos.sdk.transaction.signer.TransactionSignerServcie;
import org.fisco.bcos.sdk.transaction.tools.ContractLoader;

public class AssembleTransactionWithRemoteSignProcessor
extends AssembleTransactionProcessor
implements AssembleTransactionWithRemoteSignProviderInterface {
    private final RemoteSignProviderInterface transactionSignProvider;

    public AssembleTransactionWithRemoteSignProcessor(Client client, CryptoKeyPair cryptoKeyPair, Integer groupId, String chainId, String contractName, RemoteSignProviderInterface transactionSignProvider) {
        super(client, cryptoKeyPair, groupId, chainId, contractName, "", "");
        this.transactionSignProvider = transactionSignProvider;
        this.transactionEncoder = new TransactionEncoderService(this.cryptoSuite, transactionSignProvider);
    }

    public AssembleTransactionWithRemoteSignProcessor(Client client, CryptoKeyPair cryptoKeyPair, Integer groupId, String chainId, ContractLoader contractLoader, RemoteSignProviderInterface transactionSignProvider) {
        super(client, cryptoKeyPair, groupId, chainId, contractLoader);
        this.transactionSignProvider = transactionSignProvider;
        this.transactionEncoder = new TransactionEncoderService(this.cryptoSuite, transactionSignProvider);
    }

    @Override
    public TransactionResponse deployAndGetResponse(String abi, String bin, List<Object> params) throws ABICodecException {
        return this.deployAndGetResponse(abi, bin, this.createSignedConstructor(abi, bin, params));
    }

    @Override
    public void deployAsync(RawTransaction rawTransaction, RemoteSignCallbackInterface remoteSignCallbackInterface) throws ABICodecException {
        byte[] rawTxHash = this.transactionEncoder.encodeAndHashBytes(rawTransaction, this.cryptoKeyPair);
        this.transactionSignProvider.requestForSignAsync(rawTxHash, this.cryptoSuite.getCryptoTypeConfig(), remoteSignCallbackInterface);
    }

    @Override
    public void deployAsync(String abi, String bin, List<Object> params, RemoteSignCallbackInterface remoteSignCallbackInterface) throws ABICodecException {
        RawTransaction rawTransaction = this.getRawTransactionForConstructor(abi, bin, params);
        byte[] rawTxHash = this.transactionEncoder.encodeAndHashBytes(rawTransaction, this.cryptoKeyPair);
        this.transactionSignProvider.requestForSignAsync(rawTxHash, this.cryptoSuite.getCryptoTypeConfig(), remoteSignCallbackInterface);
    }

    @Override
    public CompletableFuture<TransactionReceipt> deployAsync(String abi, String bin, List<Object> params) throws ABICodecException {
        RawTransaction rawTransaction = this.getRawTransactionForConstructor(abi, bin, params);
        byte[] rawTxHash = this.transactionEncoder.encodeAndHashBytes(rawTransaction, this.cryptoKeyPair);
        return this.signAndPush(rawTransaction, rawTxHash);
    }

    @Override
    public void deployByContractLoaderAsync(String contractName, List<Object> args, RemoteSignCallbackInterface remoteSignCallbackInterface) throws ABICodecException, NoSuchTransactionFileException {
        this.deployAsync(this.contractLoader.getABIByContractName(contractName), this.contractLoader.getBinaryByContractName(contractName), args, remoteSignCallbackInterface);
    }

    @Override
    public void sendTransactionAndGetReceiptByContractLoaderAsync(String contractName, String to, String functionName, List<Object> params, RemoteSignCallbackInterface remoteSignCallbackInterface) throws ABICodecException, TransactionBaseException {
        this.sendTransactionAsync(to, this.contractLoader.getABIByContractName(contractName), functionName, params, remoteSignCallbackInterface);
    }

    @Override
    public CompletableFuture<TransactionReceipt> sendTransactionAsync(String to, String abi, String functionName, List<Object> params, RemoteSignCallbackInterface remoteSignCallbackInterface) throws ABICodecException {
        RawTransaction rawTransaction = this.getRawTransaction(to, abi, functionName, params);
        byte[] rawTxHash = this.transactionEncoder.encodeAndHashBytes(rawTransaction, this.cryptoKeyPair);
        this.transactionSignProvider.requestForSignAsync(rawTxHash, this.cryptoSuite.getCryptoTypeConfig(), remoteSignCallbackInterface);
        return this.signAndPush(rawTransaction, rawTxHash);
    }

    @Override
    public CompletableFuture<TransactionReceipt> sendTransactionAsync(String to, String abi, String functionName, List<Object> params) throws ABICodecException {
        RawTransaction rawTransaction = this.getRawTransaction(to, abi, functionName, params);
        byte[] rawTxHash = this.transactionEncoder.encodeAndHashBytes(rawTransaction, this.cryptoKeyPair);
        return this.signAndPush(rawTransaction, rawTxHash);
    }

    @Override
    public TransactionReceipt signAndPush(RawTransaction rawTransaction, String signatureStr) {
        SignatureResult signatureResult = TransactionSignerServcie.decodeSignatureString(signatureStr, this.cryptoSuite.getCryptoTypeConfig(), this.cryptoSuite.createKeyPair().getHexPublicKey());
        byte[] signedTransaction = this.transactionEncoder.encode(rawTransaction, signatureResult);
        return this.transactionPusher.push(Hex.toHexString((byte[])signedTransaction));
    }

    @Override
    public CompletableFuture<TransactionReceipt> signAndPush(RawTransaction rawTransaction, byte[] rawTxHash) {
        CompletableFuture<SignatureResult> future = CompletableFuture.supplyAsync(() -> this.transactionSignProvider.requestForSign(rawTxHash, this.cryptoSuite.getCryptoTypeConfig()));
        future.exceptionally(e -> {
            log.error("Request remote sign Error: {}", (Object)e.getMessage());
            return null;
        });
        CompletionStage cr = future.thenApplyAsync(s -> {
            if (s == null) {
                log.error("Request remote signature is null");
                return null;
            }
            return this.signAndPush(rawTransaction, s.convertToString());
        });
        log.info("Sign and push over, wait for callback...");
        return cr;
    }
}

