/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.eventsub.filter;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fisco.bcos.sdk.eventsub.EventCallback;
import org.fisco.bcos.sdk.eventsub.filter.EventLogFilter;
import org.fisco.bcos.sdk.eventsub.filter.EventLogFilterStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterManager {
    private static final Logger logger = LoggerFactory.getLogger(FilterManager.class);
    private Map<String, EventLogFilter> regId2Filter = new ConcurrentHashMap<String, EventLogFilter>();
    private Map<String, EventCallback> filterID2Callback = new ConcurrentHashMap<String, EventCallback>();

    public List<EventLogFilter> getAllSubscribedEvent() {
        ArrayList<EventLogFilter> list = new ArrayList<EventLogFilter>();
        this.regId2Filter.forEach((regId, filter) -> list.add((EventLogFilter)filter));
        return list;
    }

    public EventLogFilter getFilterById(String filterId) {
        for (EventLogFilter filter : this.regId2Filter.values()) {
            if (!filter.getFilterID().equals(filterId)) continue;
            return filter;
        }
        return null;
    }

    public void addFilter(EventLogFilter filter) {
        this.regId2Filter.put(filter.getRegisterID(), filter);
        logger.info("add event log filter , registerID: {}, filter: {}", (Object)filter.getRegisterID(), (Object)filter);
    }

    public EventLogFilter getFilter(String registerId) {
        return this.regId2Filter.get(registerId);
    }

    public void removeFilter(String registerId) {
        logger.info("remove filter, registerID: {}", (Object)registerId);
        this.regId2Filter.remove(registerId);
    }

    public void addCallback(String filterID, EventCallback callback) {
        this.filterID2Callback.put(filterID, callback);
    }

    public void removeCallback(String filterID) {
        this.filterID2Callback.remove(filterID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFilterStatus(EventLogFilter filter, EventLogFilterStatus status, ChannelHandlerContext ctx) {
        FilterManager filterManager = this;
        synchronized (filterManager) {
            filter.setStatus(status);
            filter.setCtx(ctx);
        }
    }

    public EventCallback getCallBack(String filterID) {
        return this.filterID2Callback.get(filterID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventLogFilter> getWaitingReqFilters() {
        ArrayList<EventLogFilter> filters = new ArrayList<EventLogFilter>();
        FilterManager filterManager = this;
        synchronized (filterManager) {
            for (EventLogFilter filter : this.regId2Filter.values()) {
                logger.trace(" filter in list, id:{}, status:{}", (Object)filter.getFilterID(), (Object)filter.getStatus());
                if (filter.getStatus() != EventLogFilterStatus.WAITING_REQUEST) continue;
                logger.info(" resend filter, update event filter status: {}, registerID: {}, filter: {}", new Object[]{filter.getStatus(), filter.getRegisterID(), filter});
                filters.add(filter);
                filter.setStatus(EventLogFilterStatus.WAITING_RESPONSE);
            }
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEventLogFilterStatus(ChannelHandlerContext ctx) {
        FilterManager filterManager = this;
        synchronized (filterManager) {
            for (EventLogFilter filter : this.regId2Filter.values()) {
                if (filter.getCtx() != ctx) continue;
                filter.setCtx(null);
                filter.setStatus(EventLogFilterStatus.WAITING_REQUEST);
                this.removeCallback(filter.getFilterID());
                logger.info(" disconnect, update event filter status, ctx: {}, status: {}, registerID: {}, filterID: {}, filter: {}", new Object[]{System.identityHashCode(ctx), filter.getStatus(), filter.getFilterID(), filter.getRegisterID(), filter});
            }
        }
    }
}

