/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.eventsub.filter;

public enum EventSubNodeRespStatus {
    SUCCESS(0),
    PUSH_COMPLETED(1),
    INVALID_PARAMS(-41000),
    INVALID_REQUEST(-41001),
    GROUP_NOT_EXIST(-41002),
    INVALID_RANGE(-41003),
    INVALID_RESPONSE(-41004),
    REQUEST_TIMEOUT(-41005),
    SDK_PERMISSION_DENIED(-41006),
    OTHER_ERROR(42000);

    private int status;

    private EventSubNodeRespStatus(int status) {
        this.setStatus(status);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public static EventSubNodeRespStatus fromIntStatus(int status) {
        for (EventSubNodeRespStatus e : EventSubNodeRespStatus.values()) {
            if (e.getStatus() != status) continue;
            return e;
        }
        return OTHER_ERROR;
    }

    public static String getDescMessage(int status) {
        return EventSubNodeRespStatus.getDescMessage(EventSubNodeRespStatus.fromIntStatus(status));
    }

    public static String getDescMessage(EventSubNodeRespStatus status) {
        String desc;
        switch (status) {
            case SUCCESS: {
                desc = "success";
                break;
            }
            case PUSH_COMPLETED: {
                desc = "push completed";
                break;
            }
            case INVALID_PARAMS: {
                desc = "params invalid";
                break;
            }
            case INVALID_REQUEST: {
                desc = "register request not valid format";
                break;
            }
            case REQUEST_TIMEOUT: {
                desc = "register request timeout";
                break;
            }
            case GROUP_NOT_EXIST: {
                desc = "group not exist";
                break;
            }
            case INVALID_RANGE: {
                desc = "register parameters not in a range within permision";
                break;
            }
            case INVALID_RESPONSE: {
                desc = "response message not invalid format";
                break;
            }
            case SDK_PERMISSION_DENIED: {
                desc = "the SDK is not allowed to access this group.";
                break;
            }
            default: {
                desc = "other errors";
            }
        }
        return desc;
    }
}

