/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.crypto.vrf;

import com.webank.fisco.bcos.wedpr.sdk.NativeInterface;
import com.webank.fisco.bcos.wedpr.sdk.SdkResult;
import java.math.BigInteger;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.keypair.ECDSAKeyPair;
import org.fisco.bcos.sdk.crypto.vrf.VRFException;
import org.fisco.bcos.sdk.crypto.vrf.VRFInterface;
import org.fisco.bcos.sdk.crypto.vrf.VRFKeyPair;
import org.fisco.bcos.sdk.utils.Numeric;

public class Curve25519VRF
implements VRFInterface {
    private final ECDSAKeyPair keyPairGenerator = new ECDSAKeyPair();

    @Override
    public VRFKeyPair createKeyPair() {
        CryptoKeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        return new VRFKeyPair(1000, keyPair.getHexPrivateKey());
    }

    @Override
    public String generateVRFProof(String privateKey, String vrfInput) {
        SdkResult result = NativeInterface.curve25519VrfProveUtf8((String)Numeric.getKeyNoPrefix("04", privateKey, 64), (String)vrfInput);
        if (result.wedprErrorMessage != null && !result.wedprErrorMessage.isEmpty()) {
            throw new VRFException("generate VRF Proof failed: " + result.wedprErrorMessage);
        }
        return result.vrfProof;
    }

    @Override
    public boolean verify(String publicKey, String vrfInput, String vrfProof) {
        SdkResult result = NativeInterface.curve25519VrfVerifyUtf8((String)publicKey, (String)vrfInput, (String)vrfProof);
        if (result.wedprErrorMessage != null && !result.wedprErrorMessage.isEmpty()) {
            return false;
        }
        return result.booleanResult;
    }

    @Override
    public String getPublicKeyFromPrivateKey(String privateKey) {
        SdkResult result = NativeInterface.curve25519VrfDerivePublicKey((String)Numeric.getKeyNoPrefix("04", privateKey, 64));
        if (result.wedprErrorMessage != null && !result.wedprErrorMessage.isEmpty()) {
            throw new VRFException("get VRF Proof failed: " + result.wedprErrorMessage);
        }
        return result.publicKey;
    }

    @Override
    public String vrfProofToHash(String vrfProof) {
        SdkResult result = NativeInterface.curve25519VrfProofToHash((String)vrfProof);
        if (result.wedprErrorMessage != null && !result.wedprErrorMessage.isEmpty()) {
            throw new VRFException("convert VRF Proof to hash failed:" + result.wedprErrorMessage);
        }
        return result.hash;
    }

    @Override
    public BigInteger vrfProofToRandomValue(String vrfProof) {
        return new BigInteger(this.vrfProofToHash(vrfProof), 16);
    }

    @Override
    public boolean isValidVRFPublicKey(String vrfPublicKey) {
        SdkResult result = NativeInterface.curve25519VrfIsValidPublicKey((String)vrfPublicKey);
        if (result.wedprErrorMessage != null && !result.wedprErrorMessage.isEmpty()) {
            return false;
        }
        return result.booleanResult;
    }
}

