/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.contract.precompiled.crud.table;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fisco.bcos.sdk.abi.FunctionReturnDecoder;
import org.fisco.bcos.sdk.abi.TypeReference;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Function;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.Int256;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple1;
import org.fisco.bcos.sdk.abi.datatypes.generated.tuples.generated.Tuple3;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.contract.Contract;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.TransactionReceipt;
import org.fisco.bcos.sdk.model.callback.TransactionCallback;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;

public class TableFactory
extends Contract {
    public static final String[] BINARY_ARRAY = new String[0];
    public static final String BINARY = String.join((CharSequence)"", BINARY_ARRAY);
    public static final String[] SM_BINARY_ARRAY = new String[0];
    public static final String SM_BINARY = String.join((CharSequence)"", SM_BINARY_ARRAY);
    public static final String[] ABI_ARRAY = new String[]{"[{\"constant\":false,\"inputs\":[{\"name\":\"\",\"type\":\"string\"},{\"name\":\"\",\"type\":\"string\"},{\"name\":\"\",\"type\":\"string\"}],\"name\":\"createTable\",\"outputs\":[{\"name\":\"\",\"type\":\"int256\"}],\"payable\":false,\"stateMutability\":\"nonpayable\",\"type\":\"function\"},{\"constant\":true,\"inputs\":[{\"name\":\"\",\"type\":\"string\"}],\"name\":\"openTable\",\"outputs\":[{\"name\":\"\",\"type\":\"address\"}],\"payable\":false,\"stateMutability\":\"view\",\"type\":\"function\"}]"};
    public static final String ABI = String.join((CharSequence)"", ABI_ARRAY);
    public static final String FUNC_CREATETABLE = "createTable";
    public static final String FUNC_OPENTABLE = "openTable";

    protected TableFactory(String contractAddress, Client client, CryptoKeyPair credential) {
        super(TableFactory.getBinary(client.getCryptoSuite()), contractAddress, client, credential);
    }

    public static String getBinary(CryptoSuite cryptoSuite) {
        return cryptoSuite.getCryptoTypeConfig() == 0 ? BINARY : SM_BINARY;
    }

    public TransactionReceipt createTable(String param0, String param1, String param2) {
        Function function = new Function(FUNC_CREATETABLE, Arrays.asList(new Utf8String(param0), new Utf8String(param1), new Utf8String(param2)), Collections.emptyList());
        return this.executeTransaction(function);
    }

    public void createTable(String param0, String param1, String param2, TransactionCallback callback) {
        Function function = new Function(FUNC_CREATETABLE, Arrays.asList(new Utf8String(param0), new Utf8String(param1), new Utf8String(param2)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public String getSignedTransactionForCreateTable(String param0, String param1, String param2) {
        Function function = new Function(FUNC_CREATETABLE, Arrays.asList(new Utf8String(param0), new Utf8String(param1), new Utf8String(param2)), Collections.emptyList());
        return this.createSignedTransaction(function);
    }

    public Tuple3<String, String, String> getCreateTableInput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getInput().substring(10);
        Function function = new Function(FUNC_CREATETABLE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}, new TypeReference<Utf8String>(){}, new TypeReference<Utf8String>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple3<String, String, String>((String)results.get(0).getValue(), (String)results.get(1).getValue(), (String)results.get(2).getValue());
    }

    public Tuple1<BigInteger> getCreateTableOutput(TransactionReceipt transactionReceipt) {
        String data = transactionReceipt.getOutput();
        Function function = new Function(FUNC_CREATETABLE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Int256>(){}));
        List<Type> results = FunctionReturnDecoder.decode(data, function.getOutputParameters());
        return new Tuple1<BigInteger>((BigInteger)results.get(0).getValue());
    }

    public String openTable(String param0) throws ContractException {
        Function function = new Function(FUNC_OPENTABLE, Arrays.asList(new Utf8String(param0)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeCallWithSingleValueReturn(function, String.class);
    }

    public static TableFactory load(String contractAddress, Client client, CryptoKeyPair credential) {
        return new TableFactory(contractAddress, client, credential);
    }

    public static TableFactory deploy(Client client, CryptoKeyPair credential) throws ContractException {
        return TableFactory.deploy(TableFactory.class, client, credential, TableFactory.getBinary(client.getCryptoSuite()), "");
    }
}

