/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi.datatypes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.fisco.bcos.sdk.abi.datatypes.Type;

public abstract class Array<T extends Type>
implements Type<List<T>> {
    private String type;
    protected final List<T> value;

    @SafeVarargs
    Array(String type, T ... values) {
        if (!this.valid((Type[])values, type)) {
            throw new UnsupportedOperationException("If empty list is provided, use empty array instance");
        }
        this.type = type;
        this.value = Arrays.asList(values);
    }

    Array(String type, List<T> values) {
        if (!this.valid(values, type)) {
            throw new UnsupportedOperationException("If empty list is provided, use empty array instance");
        }
        this.type = type;
        this.value = values;
    }

    Array(String type) {
        this.type = type;
        this.value = Collections.emptyList();
    }

    @Override
    public List<T> getValue() {
        return this.value;
    }

    public List getNativeValue() {
        ArrayList list = new ArrayList(this.value.size());
        for (Type t : this.value) {
            list.add(t.getValue());
        }
        return list;
    }

    @Override
    public String getTypeAsString() {
        return this.type;
    }

    private boolean valid(T[] values, String type) {
        return values != null && values.length != 0 || type != null;
    }

    private boolean valid(List<T> values, String type) {
        return values != null && values.size() != 0 || type != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Array array = (Array)o;
        if (!this.type.equals(array.type)) {
            return false;
        }
        return this.value != null ? this.value.equals(array.value) : array.value == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public abstract boolean dynamicType();
}

