/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi;

import java.lang.reflect.ParameterizedType;
import org.fisco.bcos.sdk.abi.Utils;
import org.fisco.bcos.sdk.abi.datatypes.Type;

public abstract class TypeReference<T extends Type>
implements Comparable<TypeReference<T>> {
    private final java.lang.reflect.Type type;
    private final boolean indexed;

    protected TypeReference() {
        this(false);
    }

    protected TypeReference(boolean indexed) {
        java.lang.reflect.Type superclass = this.getClass().getGenericSuperclass();
        if (superclass instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        this.type = ((ParameterizedType)superclass).getActualTypeArguments()[0];
        this.indexed = indexed;
    }

    @Override
    public int compareTo(TypeReference<T> o) {
        return 0;
    }

    public java.lang.reflect.Type getType() {
        return this.type;
    }

    public boolean isIndexed() {
        return this.indexed;
    }

    public Class<T> getClassType() throws ClassNotFoundException {
        return Utils.getClassType(this.getType());
    }

    public static <T extends Type> TypeReference<T> create(Class<T> cls) {
        return TypeReference.create(cls, false);
    }

    public static <T extends Type> TypeReference<T> create(final Class<T> cls, boolean indexed) {
        return new TypeReference<T>(indexed){

            @Override
            public java.lang.reflect.Type getType() {
                return cls;
            }
        };
    }
}

