/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.abi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import org.fisco.bcos.sdk.abi.FunctionReturnDecoder;
import org.fisco.bcos.sdk.abi.TypeReference;
import org.fisco.bcos.sdk.abi.Utils;
import org.fisco.bcos.sdk.abi.datatypes.Address;
import org.fisco.bcos.sdk.abi.datatypes.Array;
import org.fisco.bcos.sdk.abi.datatypes.Bool;
import org.fisco.bcos.sdk.abi.datatypes.Bytes;
import org.fisco.bcos.sdk.abi.datatypes.DynamicArray;
import org.fisco.bcos.sdk.abi.datatypes.DynamicBytes;
import org.fisco.bcos.sdk.abi.datatypes.DynamicStruct;
import org.fisco.bcos.sdk.abi.datatypes.Fixed;
import org.fisco.bcos.sdk.abi.datatypes.FixedPointType;
import org.fisco.bcos.sdk.abi.datatypes.Int;
import org.fisco.bcos.sdk.abi.datatypes.IntType;
import org.fisco.bcos.sdk.abi.datatypes.NumericType;
import org.fisco.bcos.sdk.abi.datatypes.StaticArray;
import org.fisco.bcos.sdk.abi.datatypes.StaticStruct;
import org.fisco.bcos.sdk.abi.datatypes.StructType;
import org.fisco.bcos.sdk.abi.datatypes.Type;
import org.fisco.bcos.sdk.abi.datatypes.Ufixed;
import org.fisco.bcos.sdk.abi.datatypes.Uint;
import org.fisco.bcos.sdk.abi.datatypes.Utf8String;
import org.fisco.bcos.sdk.abi.datatypes.generated.Uint160;
import org.fisco.bcos.sdk.utils.Numeric;

public class TypeDecoder {
    static final int MAX_BYTE_LENGTH_FOR_HEX_STRING = 64;

    public static <T extends Type> T decode(String input, int offset, Class<T> type) {
        if (NumericType.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeNumeric(input.substring(offset), type);
        }
        if (Address.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeAddress(input.substring(offset));
        }
        if (Bool.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeBool(input, offset);
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeBytes(input, offset, type);
        }
        if (DynamicBytes.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeDynamicBytes(input, offset);
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeUtf8String(input, offset);
        }
        if (Array.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Array types must be wrapped in a TypeReference");
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + type.getClass());
    }

    static Address decodeAddress(String input) {
        return new Address(TypeDecoder.decodeNumeric(input, Uint160.class));
    }

    static <T extends NumericType> T decodeNumeric(String input, Class<T> type) {
        try {
            byte[] inputByteArray = Numeric.hexStringToByteArray(input);
            int typeLengthAsBytes = TypeDecoder.getTypeLengthInBytes(type);
            byte[] resultByteArray = new byte[typeLengthAsBytes + 1];
            if (Int.class.isAssignableFrom(type) || Fixed.class.isAssignableFrom(type)) {
                resultByteArray[0] = inputByteArray[0];
            }
            int valueOffset = 32 - typeLengthAsBytes;
            System.arraycopy(inputByteArray, valueOffset, resultByteArray, 1, typeLengthAsBytes);
            BigInteger numericValue = new BigInteger(resultByteArray);
            return (T)((NumericType)type.getConstructor(BigInteger.class).newInstance(numericValue));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static <T extends NumericType> int getTypeLengthInBytes(Class<T> type) {
        return TypeDecoder.getTypeLength(type) >> 3;
    }

    static <T extends NumericType> int getTypeLength(Class<T> type) {
        if (IntType.class.isAssignableFrom(type)) {
            String regex = "(" + Uint.class.getSimpleName() + "|" + Int.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                return Integer.parseInt(splitName[1]);
            }
        } else if (FixedPointType.class.isAssignableFrom(type)) {
            String regex = "(" + Ufixed.class.getSimpleName() + "|" + Fixed.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                String[] bitsCounts = splitName[1].split("x");
                return Integer.parseInt(bitsCounts[0]) + Integer.parseInt(bitsCounts[1]);
            }
        }
        return 256;
    }

    static int decodeUintAsInt(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        return TypeDecoder.decode(input, 0, Uint.class).getValue().intValue();
    }

    static Bool decodeBool(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        BigInteger numericValue = Numeric.toBigInt(input);
        boolean value = numericValue.equals(BigInteger.ONE);
        return new Bool(value);
    }

    static <T extends Bytes> T decodeBytes(String input, Class<T> type) {
        return TypeDecoder.decodeBytes(input, 0, type);
    }

    static <T extends Bytes> T decodeBytes(String input, int offset, Class<T> type) {
        try {
            String simpleName = type.getSimpleName();
            String[] splitName = simpleName.split(Bytes.class.getSimpleName());
            int length = Integer.parseInt(splitName[1]);
            int hexStringLength = length << 1;
            byte[] bytes = Numeric.hexStringToByteArray(input.substring(offset, offset + hexStringLength));
            return (T)((Bytes)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static DynamicBytes decodeDynamicBytes(String input, int offset) {
        int encodedLength = TypeDecoder.decodeUintAsInt(input, offset);
        int hexStringEncodedLength = encodedLength << 1;
        int valueOffset = offset + 64;
        String data = input.substring(valueOffset, valueOffset + hexStringEncodedLength);
        byte[] bytes = Numeric.hexStringToByteArray(data);
        return new DynamicBytes(bytes);
    }

    static Utf8String decodeUtf8String(String input, int offset) {
        DynamicBytes dynamicBytesResult = TypeDecoder.decodeDynamicBytes(input, offset);
        byte[] bytes = dynamicBytesResult.getValue();
        return new Utf8String(new String(bytes, StandardCharsets.UTF_8));
    }

    public static <T extends Type> T decodeStaticArray(String input, int offset, java.lang.reflect.Type type, int length) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStaticArray(type, elements);
        };
        return (T)TypeDecoder.decodeArrayElements(input, offset, type, length, function);
    }

    private static <T extends Type> T instantiateStaticArray(java.lang.reflect.Type type, List<T> elements) {
        try {
            Class cls = Utils.getClassType(type);
            return (T)((Type)cls.getConstructor(List.class).newInstance(elements));
        }
        catch (ReflectiveOperationException e) {
            return (T)new StaticArray<T>(elements);
        }
    }

    public static <T extends Type> T decodeDynamicArray(String input, int offset, java.lang.reflect.Type type) {
        int length = TypeDecoder.decodeUintAsInt(input, offset);
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                return DynamicArray.empty(typeName);
            }
            return new DynamicArray(elements);
        };
        int valueOffset = offset + 64;
        return (T)TypeDecoder.decodeArrayElements(input, valueOffset, type, length, function);
    }

    private static <T extends Type> T decodeArrayElements(String input, int offset, java.lang.reflect.Type type, int length, BiFunction<List<T>, String, T> consumer) {
        try {
            ArrayList elements = new ArrayList(length);
            java.lang.reflect.Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            Class paraType = Utils.getClassType(types[0]);
            if (StructType.class.isAssignableFrom(paraType)) {
                int i = 0;
                int currOffset = offset;
                while (i < length) {
                    Object value = DynamicStruct.class.isAssignableFrom(paraType) ? TypeDecoder.decodeDynamicStruct(input, offset + FunctionReturnDecoder.getDataOffset(input, currOffset, type), TypeReference.create(paraType)) : TypeDecoder.decodeStaticStruct(input, currOffset, TypeReference.create(paraType));
                    elements.add(value);
                    ++i;
                    currOffset += TypeDecoder.getSingleElementLength(input, currOffset, paraType) * 64;
                }
                String typeName = Utils.getSimpleTypeName(paraType);
                return (T)((Type)consumer.apply(elements, typeName));
            }
            for (int i = 0; i < length; ++i) {
                int currEleOffset = offset + i * 64 * Utils.getOffset(types[0]);
                Object t = null;
                if (Array.class.isAssignableFrom(paraType)) {
                    int size = 0;
                    if (StaticArray.class.isAssignableFrom(paraType)) {
                        size = Integer.parseInt(Utils.getClassType(types[0]).getSimpleName().substring(StaticArray.class.getSimpleName().length()));
                        t = TypeDecoder.decodeStaticArray(input, currEleOffset, types[0], size);
                    } else {
                        int getOffset = TypeDecoder.decodeUintAsInt(input, currEleOffset) << 1;
                        t = TypeDecoder.decodeDynamicArray(input, offset + getOffset, types[0]);
                    }
                } else if (Utf8String.class.isAssignableFrom(paraType) || DynamicBytes.class.isAssignableFrom(paraType)) {
                    int getOffset = TypeDecoder.decodeUintAsInt(input, currEleOffset) << 1;
                    t = TypeDecoder.decode(input, offset + getOffset, paraType);
                } else {
                    t = TypeDecoder.decode(input, currEleOffset, paraType);
                }
                elements.add(t);
            }
            String typeName = Utils.getSimpleTypeName(paraType);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + type.getTypeName(), e);
        }
    }

    static <T extends Type> int getSingleElementLength(String input, int offset, Class<T> type) {
        if (input.length() == offset) {
            return 0;
        }
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeUintAsInt(input, offset) / 64 + 2;
        }
        if (StaticStruct.class.isAssignableFrom(type)) {
            return Utils.staticStructNestedPublicFieldsFlatList(type).size();
        }
        return 1;
    }

    static <T extends Type> T decodeDynamicStruct(String input, int offset, TypeReference<T> typeReference) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStruct(typeReference, elements);
        };
        return (T)TypeDecoder.decodeDynamicStructElements(input, offset, typeReference, function);
    }

    private static <T extends Type> T instantiateStruct(TypeReference<T> typeReference, List<T> parameters) {
        try {
            Constructor ctor = Arrays.stream(typeReference.getClassType().getDeclaredConstructors()).filter(declaredConstructor -> Arrays.stream(declaredConstructor.getParameterTypes()).allMatch(Type.class::isAssignableFrom)).findAny().orElseThrow(() -> new RuntimeException("TypeReference struct must contain a constructor with types that extend Type"));
            ctor.setAccessible(true);
            return (T)((Type)ctor.newInstance(parameters.toArray()));
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException("Constructor cannot accept" + Arrays.toString(parameters.toArray()), e);
        }
    }

    private static <T extends Type> T decodeDynamicStructElements(String input, int offset, TypeReference<T> typeReference, BiFunction<List<T>, String, T> consumer) {
        try {
            Class<Type> classType = typeReference.getClassType();
            Constructor constructor = Arrays.stream(classType.getDeclaredConstructors()).filter(declaredConstructor -> Arrays.stream(declaredConstructor.getParameterTypes()).allMatch(Type.class::isAssignableFrom)).findAny().orElseThrow(() -> new RuntimeException("TypeReferenced struct must contain a constructor with types that extend Type"));
            int length = constructor.getParameterCount();
            HashMap<Integer, Object> parameters = new HashMap<Integer, Object>();
            int staticOffset = 0;
            ArrayList<Integer> parameterOffsets = new ArrayList<Integer>();
            for (int i = 0; i < length; ++i) {
                Object value;
                Class<?> declaredField = constructor.getParameterTypes()[i];
                int beginIndex = offset + staticOffset;
                if (TypeDecoder.isDynamic(declaredField)) {
                    int parameterOffset = TypeDecoder.decodeDynamicStructDynamicParameterOffset(input.substring(beginIndex, beginIndex + 64)) + offset;
                    parameterOffsets.add(parameterOffset);
                    staticOffset += 64;
                    continue;
                }
                if (StaticStruct.class.isAssignableFrom(declaredField)) {
                    value = TypeDecoder.decodeStaticStruct(input.substring(beginIndex), 0, TypeReference.create(declaredField));
                    staticOffset += Utils.staticStructNestedPublicFieldsFlatList(classType).size() * 64;
                } else {
                    value = TypeDecoder.decode(input.substring(beginIndex), 0, declaredField);
                    staticOffset += 64;
                }
                parameters.put(i, value);
            }
            int dynamicParametersProcessed = 0;
            int dynamicParametersToProcess = TypeDecoder.getDynamicStructDynamicParametersCount(constructor.getParameterTypes());
            for (int i = 0; i < length; ++i) {
                java.lang.reflect.Type genericParameterType = constructor.getGenericParameterTypes()[i];
                TypeReference typeReferenceElement = TypeReference.create(Utils.getClassType(genericParameterType));
                if (!TypeDecoder.isDynamic(typeReferenceElement.getClassType())) continue;
                boolean isLastParameterInStruct = dynamicParametersProcessed == dynamicParametersToProcess - 1;
                int parameterLength = isLastParameterInStruct ? input.length() - (Integer)parameterOffsets.get(dynamicParametersProcessed) : (Integer)parameterOffsets.get(dynamicParametersProcessed + 1) - (Integer)parameterOffsets.get(dynamicParametersProcessed);
                parameters.put(i, TypeDecoder.decodeDynamicParameterFromStruct(input, (Integer)parameterOffsets.get(dynamicParametersProcessed), parameterLength, typeReferenceElement, genericParameterType));
                ++dynamicParametersProcessed;
            }
            String typeName = Utils.getSimpleTypeName(classType);
            ArrayList elements = new ArrayList();
            for (int i = 0; i < length; ++i) {
                elements.add(parameters.get(i));
            }
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }

    static <T extends Type> boolean isDynamic(Class<T> parameter) {
        return DynamicBytes.class.isAssignableFrom(parameter) || Utf8String.class.isAssignableFrom(parameter) || DynamicArray.class.isAssignableFrom(parameter);
    }

    private static int decodeDynamicStructDynamicParameterOffset(String input) {
        return TypeDecoder.decodeUintAsInt(input, 0) << 1;
    }

    public static <T extends Type> T decodeStaticStruct(String input, int offset, TypeReference<T> typeReference) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStruct(typeReference, elements);
        };
        return (T)TypeDecoder.decodeStaticStructElement(input, offset, typeReference, function);
    }

    private static <T extends Type> T decodeStaticStructElement(String input, int offset, TypeReference<T> typeReference, BiFunction<List<T>, String, T> consumer) {
        try {
            Class<T> classType = typeReference.getClassType();
            Constructor constructor = Arrays.stream(classType.getDeclaredConstructors()).filter(declaredConstructor -> Arrays.stream(declaredConstructor.getParameterTypes()).allMatch(Type.class::isAssignableFrom)).findAny().orElseThrow(() -> new RuntimeException("TypeReferenced struct must contain a constructor with types that extend Type"));
            int length = constructor.getParameterCount();
            ArrayList elements = new ArrayList(length);
            int currOffset = offset;
            for (int i = 0; i < length; ++i) {
                Object value;
                Class<?> declaredField = constructor.getParameterTypes()[i];
                if (StaticStruct.class.isAssignableFrom(declaredField)) {
                    int nestedStructLength = classType.getDeclaredFields()[i].getType().getConstructors()[0].getParameters().length * 64;
                    value = TypeDecoder.decodeStaticStruct(input.substring(currOffset, currOffset + nestedStructLength), 0, TypeReference.create(declaredField));
                    currOffset += nestedStructLength;
                } else {
                    value = TypeDecoder.decode(input.substring(currOffset, currOffset + 64), 0, declaredField);
                    currOffset += 64;
                }
                elements.add(value);
            }
            String typeName = Utils.getSimpleTypeName(classType);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + typeReference.getType().getTypeName(), e);
        }
    }

    private static <T extends Type> int getDynamicStructDynamicParametersCount(Class<?>[] cls) {
        return (int)Arrays.stream(cls).filter(c -> TypeDecoder.isDynamic(c)).count();
    }

    private static <T extends Type> T decodeDynamicParameterFromStruct(String input, int parameterOffset, int parameterLength, TypeReference<T> typeReference, java.lang.reflect.Type genericParameterType) throws ClassNotFoundException {
        String dynamicElementData = input.substring(parameterOffset, parameterOffset + parameterLength);
        T value = DynamicStruct.class.isAssignableFrom(typeReference.getClassType()) ? TypeDecoder.decodeDynamicStruct(dynamicElementData, 0, typeReference) : (DynamicArray.class.isAssignableFrom(typeReference.getClassType()) ? TypeDecoder.decodeDynamicArray(dynamicElementData, 0, genericParameterType) : TypeDecoder.decode(dynamicElementData, 0, typeReference.getClassType()));
        return value;
    }
}

