/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.signer;

import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.crypto.signature.ECDSASignatureResult;
import org.fisco.bcos.sdk.crypto.signature.SM2SignatureResult;
import org.fisco.bcos.sdk.crypto.signature.Signature;
import org.fisco.bcos.sdk.crypto.signature.SignatureResult;
import org.fisco.bcos.sdk.transaction.signer.TransactionSignerInterface;

public class TransactionSignerServcie
implements TransactionSignerInterface {
    private Signature signature;

    public TransactionSignerServcie(Signature signature) {
        this.signature = signature;
    }

    @Override
    public SignatureResult sign(String hash, CryptoKeyPair cryptoKeyPair) {
        return this.signature.sign(hash, cryptoKeyPair);
    }

    @Override
    public SignatureResult sign(byte[] hash, CryptoKeyPair cryptoKeyPair) {
        return this.signature.sign(hash, cryptoKeyPair);
    }

    public Signature getSignature() {
        return this.signature;
    }

    public void setSignature(Signature signature) {
        this.signature = signature;
    }

    public static SignatureResult decodeSignatureString(String signatureStr, int cryptoType, String publicKey) {
        SignatureResult signature = cryptoType == 0 ? new ECDSASignatureResult(signatureStr) : new SM2SignatureResult(publicKey, signatureStr);
        return signature;
    }
}

