/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.transaction.builder;

import java.math.BigInteger;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.fisco.bcos.sdk.abi.ABICodec;
import org.fisco.bcos.sdk.abi.ABICodecException;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.transaction.builder.TransactionBuilderInterface;
import org.fisco.bcos.sdk.transaction.codec.encode.TransactionEncoderService;
import org.fisco.bcos.sdk.transaction.model.gas.DefaultGasProvider;
import org.fisco.bcos.sdk.transaction.model.po.RawTransaction;

public class TransactionBuilderService
implements TransactionBuilderInterface {
    private Client client;

    public TransactionBuilderService(Client client) {
        this.client = client;
    }

    public static String createSignedTransaction(CryptoSuite cryptoSuite, int groupId, int chainId, BigInteger blockLimit, String abi, String to, String functionName, List<Object> params) throws ABICodecException {
        ABICodec abiCodec = new ABICodec(cryptoSuite);
        String data = abiCodec.encodeMethod(abi, functionName, params);
        ThreadLocalRandom r = ThreadLocalRandom.current();
        BigInteger randomId = new BigInteger(250, r);
        RawTransaction rawTransaction = RawTransaction.createTransaction(randomId, DefaultGasProvider.GAS_PRICE, DefaultGasProvider.GAS_LIMIT, blockLimit, to, BigInteger.ZERO, data, BigInteger.valueOf(chainId), BigInteger.valueOf(groupId), "");
        TransactionEncoderService transactionEncoder = new TransactionEncoderService(cryptoSuite);
        return transactionEncoder.encodeAndSign(rawTransaction, cryptoSuite.getCryptoKeyPair());
    }

    @Override
    public RawTransaction createTransaction(BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, BigInteger chainId, BigInteger groupId, String extraData) {
        return this.createTransaction(this.client.getBlockLimit(), gasPrice, gasLimit, to, data, value, chainId, groupId, extraData);
    }

    @Override
    public RawTransaction createTransaction(BigInteger blockLimit, BigInteger gasPrice, BigInteger gasLimit, String to, String data, BigInteger value, BigInteger chainId, BigInteger groupId, String extraData) {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        BigInteger randomId = new BigInteger(250, r);
        return RawTransaction.createTransaction(randomId, gasPrice, gasLimit, blockLimit, to, value, data, chainId, groupId, extraData);
    }

    @Override
    public RawTransaction createTransaction(String to, String data, BigInteger groupId) {
        return this.createTransaction(to, data, BigInteger.ONE, groupId);
    }

    @Override
    public RawTransaction createTransaction(String to, String data, BigInteger chainId, BigInteger groupId) {
        return this.createTransaction(DefaultGasProvider.GAS_PRICE, DefaultGasProvider.GAS_LIMIT, to, data, BigInteger.ZERO, chainId, groupId, null);
    }

    @Override
    public RawTransaction createTransaction(BigInteger blockLimit, String to, String data, BigInteger chainId, BigInteger groupId) {
        return this.createTransaction(blockLimit, DefaultGasProvider.GAS_PRICE, DefaultGasProvider.GAS_LIMIT, to, data, BigInteger.ZERO, chainId, groupId, null);
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

