/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.contract.precompiled.permission;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.fisco.bcos.sdk.client.Client;
import org.fisco.bcos.sdk.contract.precompiled.model.PrecompiledVersionCheck;
import org.fisco.bcos.sdk.contract.precompiled.permission.PermissionInfo;
import org.fisco.bcos.sdk.contract.precompiled.permission.PermissionPrecompiled;
import org.fisco.bcos.sdk.crypto.keypair.CryptoKeyPair;
import org.fisco.bcos.sdk.model.RetCode;
import org.fisco.bcos.sdk.transaction.codec.decode.ReceiptParser;
import org.fisco.bcos.sdk.transaction.model.exception.ContractException;
import org.fisco.bcos.sdk.utils.ObjectMapperFactory;

public class PermissionService {
    private final PermissionPrecompiled permissionPrecompiled;
    private final String currentVersion;

    public PermissionService(Client client, CryptoKeyPair credential) {
        this.permissionPrecompiled = PermissionPrecompiled.load("0x0000000000000000000000000000000000001005", client, credential);
        this.currentVersion = client.getClientNodeVersion().getNodeVersion().getSupportedVersion();
    }

    public RetCode grantPermission(String tableName, String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.permissionPrecompiled.insert(tableName, userAddress));
    }

    public RetCode revokePermission(String tableName, String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.permissionPrecompiled.remove(tableName, userAddress));
    }

    public static List<PermissionInfo> parsePermissionInfo(String permissionInfo) throws JsonProcessingException {
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (List)objectMapper.readValue(permissionInfo, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, PermissionInfo.class));
    }

    public List<PermissionInfo> queryPermission(String contractAddress) throws ContractException {
        PrecompiledVersionCheck.QUERY_WRITE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        try {
            String permissionInfo = this.permissionPrecompiled.queryPermission(contractAddress);
            return PermissionService.parsePermissionInfo(permissionInfo);
        }
        catch (JsonProcessingException e) {
            throw new ContractException("Query permission for " + contractAddress + " failed, error info: " + e.getMessage(), e);
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public RetCode grantWrite(String contractAddress, String userAddress) throws ContractException {
        PrecompiledVersionCheck.GRANT_WRITE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.permissionPrecompiled.grantWrite(contractAddress, userAddress));
    }

    public RetCode revokeWrite(String contractAddress, String userAddress) throws ContractException {
        PrecompiledVersionCheck.REVOKE_WRITE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return ReceiptParser.parseTransactionReceipt(this.permissionPrecompiled.revokeWrite(contractAddress, userAddress));
    }

    public List<PermissionInfo> queryPermissionByTableName(String tableName) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        try {
            String permissionInfo = this.permissionPrecompiled.queryByName(tableName);
            return PermissionService.parsePermissionInfo(permissionInfo);
        }
        catch (JsonProcessingException e) {
            throw new ContractException("Query permission for " + tableName + " failed, error info: " + e.getMessage(), e);
        }
        catch (ContractException e) {
            throw ReceiptParser.parseExceptionCall(e);
        }
    }

    public RetCode grantDeployAndCreateManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.grantPermission("_sys_tables_", userAddress);
    }

    public RetCode revokeDeployAndCreateManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.revokePermission("_sys_tables_", userAddress);
    }

    public List<PermissionInfo> listDeployAndCreateManager() throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.queryPermissionByTableName("_sys_tables_");
    }

    public RetCode grantPermissionManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.grantPermission("_sys_table_access_", userAddress);
    }

    public RetCode revokePermissionManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.revokePermission("_sys_table_access_", userAddress);
    }

    public List<PermissionInfo> listPermissionManager() throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.queryPermissionByTableName("_sys_table_access_");
    }

    public RetCode grantNodeManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.grantPermission("_sys_consensus_", userAddress);
    }

    public RetCode revokeNodeManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.revokePermission("_sys_consensus_", userAddress);
    }

    public List<PermissionInfo> listNodeManager() throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.queryPermissionByTableName("_sys_consensus_");
    }

    public RetCode grantCNSManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.grantPermission("_sys_cns_", userAddress);
    }

    public RetCode revokeCNSManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.revokePermission("_sys_cns_", userAddress);
    }

    public List<PermissionInfo> listCNSManager() throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.queryPermissionByTableName("_sys_cns_");
    }

    public RetCode grantSysConfigManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.grantPermission("_sys_config_", userAddress);
    }

    public RetCode revokeSysConfigManager(String userAddress) throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.revokePermission("_sys_config_", userAddress);
    }

    public List<PermissionInfo> listSysConfigManager() throws ContractException {
        PrecompiledVersionCheck.TABLE_PERMISSION_PRECOMPILED_VERSION.checkVersion(this.currentVersion);
        return this.queryPermissionByTableName("_sys_config_");
    }
}

