/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.client.protocol.response;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.fisco.bcos.sdk.client.exceptions.ClientException;
import org.fisco.bcos.sdk.crypto.CryptoSuite;
import org.fisco.bcos.sdk.model.JsonRpcResponse;
import org.fisco.bcos.sdk.rlp.RlpEncoder;
import org.fisco.bcos.sdk.rlp.RlpList;
import org.fisco.bcos.sdk.rlp.RlpString;
import org.fisco.bcos.sdk.rlp.RlpType;
import org.fisco.bcos.sdk.utils.Hex;
import org.fisco.bcos.sdk.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BcosBlockHeader
extends JsonRpcResponse<BlockHeader> {
    private static Logger logger = LoggerFactory.getLogger(BcosBlockHeader.class);

    @Override
    public void setResult(BlockHeader result) {
        super.setResult(result);
    }

    public BlockHeader getBlockHeader() {
        return (BlockHeader)this.getResult();
    }

    public static class BlockHeader {
        protected String number;
        protected String hash;
        protected String parentHash;
        protected String logsBloom;
        protected String transactionsRoot;
        protected String receiptsRoot;
        protected String dbHash;
        protected String stateRoot;
        protected String sealer;
        protected List<String> sealerList;
        protected List<String> extraData;
        protected String gasLimit;
        protected String gasUsed;
        protected String timestamp;
        protected List<Signature> signatureList;

        public void setSignatureList(List<Signature> signatureList) {
            this.signatureList = signatureList;
        }

        public List<Signature> getSignatureList() {
            return this.signatureList;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public void setParentHash(String parentHash) {
            this.parentHash = parentHash;
        }

        public void setLogsBloom(String logsBloom) {
            this.logsBloom = logsBloom;
        }

        public void setTransactionsRoot(String transactionsRoot) {
            this.transactionsRoot = transactionsRoot;
        }

        public void setReceiptsRoot(String receiptsRoot) {
            this.receiptsRoot = receiptsRoot;
        }

        public void setDbHash(String dbHash) {
            this.dbHash = dbHash;
        }

        public void setStateRoot(String stateRoot) {
            this.stateRoot = stateRoot;
        }

        public void setSealer(String sealer) {
            this.sealer = sealer;
        }

        public void setSealerList(List<String> sealerList) {
            this.sealerList = sealerList;
        }

        public void setExtraData(List<String> extraData) {
            this.extraData = extraData;
        }

        public void setGasLimit(String gasLimit) {
            this.gasLimit = gasLimit;
        }

        public void setGasUsed(String gasUsed) {
            this.gasUsed = gasUsed;
        }

        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public BigInteger getNumber() {
            return Numeric.decodeQuantity(this.number);
        }

        public String getHash() {
            return this.hash;
        }

        public String getParentHash() {
            return this.parentHash;
        }

        public String getLogsBloom() {
            return this.logsBloom;
        }

        public String getTransactionsRoot() {
            return this.transactionsRoot;
        }

        public String getReceiptsRoot() {
            return this.receiptsRoot;
        }

        public String getDbHash() {
            return this.dbHash;
        }

        public String getStateRoot() {
            return this.stateRoot;
        }

        public String getSealer() {
            return this.sealer;
        }

        public List<String> getSealerList() {
            return this.sealerList;
        }

        public List<String> getExtraData() {
            return this.extraData;
        }

        public String getGasLimit() {
            return this.gasLimit;
        }

        public String getGasUsed() {
            return this.gasUsed;
        }

        public String getTimestamp() {
            return this.timestamp;
        }

        private byte[] encodeBlockHeader() {
            ArrayList<RlpType> encodedRlp = new ArrayList<RlpType>();
            encodedRlp.add(RlpString.create(Numeric.hexStringToByteArray(this.parentHash)));
            encodedRlp.add(RlpString.create(Numeric.hexStringToByteArray(this.stateRoot)));
            encodedRlp.add(RlpString.create(Numeric.hexStringToByteArray(this.transactionsRoot)));
            encodedRlp.add(RlpString.create(Numeric.hexStringToByteArray(this.receiptsRoot)));
            encodedRlp.add(RlpString.create(Numeric.hexStringToByteArray(this.dbHash)));
            encodedRlp.add(RlpString.create(Numeric.hexStringToByteArray(this.logsBloom)));
            encodedRlp.add(RlpString.create(Numeric.decodeQuantity(this.number)));
            encodedRlp.add(RlpString.create(Numeric.decodeQuantity(this.gasLimit)));
            encodedRlp.add(RlpString.create(Numeric.decodeQuantity(this.gasUsed)));
            encodedRlp.add(RlpString.create(Numeric.decodeQuantity(this.timestamp)));
            ArrayList<RlpType> extraDataRlp = new ArrayList<RlpType>();
            for (String string : this.extraData) {
                extraDataRlp.add(RlpString.create(Numeric.hexStringToByteArray(string)));
            }
            encodedRlp.add(new RlpList(extraDataRlp));
            encodedRlp.add(RlpString.create(Numeric.decodeQuantity(this.sealer)));
            ArrayList<RlpType> sealerListRlp = new ArrayList<RlpType>();
            for (String sealerString : this.sealerList) {
                sealerListRlp.add(RlpString.create(Numeric.hexStringToByteArray(sealerString)));
            }
            encodedRlp.add(new RlpList(sealerListRlp));
            RlpList rlpList = new RlpList(encodedRlp);
            return RlpEncoder.encode(rlpList);
        }

        public String calculateHash(CryptoSuite cryptoSuite) {
            try {
                byte[] hash = cryptoSuite.hash(this.encodeBlockHeader());
                return "0x" + Hex.toHexString(hash);
            }
            catch (Exception e) {
                logger.warn("calculateHash for the block failed, blockNumber: {}, blockHash: {}, error info: {}", new Object[]{this.hash, this.number, e.getMessage()});
                throw new ClientException("calculateHash for block " + this.hash + " failed, error info: " + e.getMessage(), e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockHeader that = (BlockHeader)o;
            return Objects.equals(Numeric.decodeQuantity(this.number), Numeric.decodeQuantity(that.number)) && Objects.equals(this.hash, that.hash) && Objects.equals(this.parentHash, that.parentHash) && Objects.equals(this.logsBloom, that.logsBloom) && Objects.equals(this.transactionsRoot, that.transactionsRoot) && Objects.equals(this.receiptsRoot, that.receiptsRoot) && Objects.equals(this.dbHash, that.dbHash) && Objects.equals(this.stateRoot, that.stateRoot) && Objects.equals(this.sealer, that.sealer) && Objects.equals(this.sealerList, that.sealerList) && Objects.equals(this.extraData, that.extraData) && Objects.equals(this.gasLimit, that.gasLimit) && Objects.equals(this.gasUsed, that.gasUsed) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.signatureList, that.signatureList);
        }

        public int hashCode() {
            return Objects.hash(Numeric.decodeQuantity(this.number), this.hash, this.parentHash, this.logsBloom, this.transactionsRoot, this.receiptsRoot, this.dbHash, this.stateRoot, this.sealer, this.sealerList, this.extraData, this.gasLimit, this.gasUsed, this.timestamp, this.signatureList);
        }

        public String toString() {
            return "BlockHeader{number=" + this.number + ", hash='" + this.hash + '\'' + ", parentHash='" + this.parentHash + '\'' + ", logsBloom='" + this.logsBloom + '\'' + ", transactionsRoot='" + this.transactionsRoot + '\'' + ", receiptsRoot='" + this.receiptsRoot + '\'' + ", dbHash='" + this.dbHash + '\'' + ", stateRoot='" + this.stateRoot + '\'' + ", sealer='" + this.sealer + '\'' + ", sealerList=" + this.sealerList + ", extraData=" + this.extraData + ", gasLimit='" + this.gasLimit + '\'' + ", gasUsed='" + this.gasUsed + '\'' + ", timestamp='" + this.timestamp + '\'' + ", signatureList=" + this.signatureList + '}';
        }
    }

    public static class Signature {
        private String index;
        private String signature;

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Signature signature1 = (Signature)o;
            return Objects.equals(this.index, signature1.index) && Objects.equals(this.signature, signature1.signature);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.signature);
        }

        public String toString() {
            return "{index='" + this.index + '\'' + ", signature='" + this.signature + '\'' + '}';
        }
    }
}

