/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.sdk.channel;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.AttributeKey;
import org.fisco.bcos.sdk.channel.model.ChannelProtocol;
import org.fisco.bcos.sdk.channel.model.EnumChannelProtocolVersion;
import org.fisco.bcos.sdk.channel.model.EnumSocketChannelAttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelVersionNegotiation {
    private static Logger logger = LoggerFactory.getLogger(ChannelVersionNegotiation.class);

    public static void setProtocolVersion(ChannelHandlerContext ctx, EnumChannelProtocolVersion version, String nodeVersion) {
        ChannelProtocol channelProtocol = new ChannelProtocol();
        channelProtocol.setProtocol(version.getVersionNumber());
        channelProtocol.setNodeVersion(nodeVersion);
        channelProtocol.setEnumProtocol(version);
        ctx.channel().attr(AttributeKey.valueOf((String)EnumSocketChannelAttributeKey.CHANNEL_PROTOCOL_KEY.getKey())).set((Object)channelProtocol);
    }

    public static void setCtxAttibuteValue(ChannelHandlerContext ctx, String key, String value) {
        AttributeKey attributeKey = AttributeKey.valueOf((String)key);
        ctx.channel().attr(attributeKey).set((Object)value);
    }

    public static EnumChannelProtocolVersion getProtocolVersion(ChannelHandlerContext ctx) {
        String host = ChannelVersionNegotiation.getPeerHost(ctx);
        AttributeKey attributeKey = AttributeKey.valueOf((String)EnumSocketChannelAttributeKey.CHANNEL_PROTOCOL_KEY.getKey());
        if (ctx.channel().hasAttr(attributeKey)) {
            ChannelProtocol channelProtocol = (ChannelProtocol)ctx.channel().attr(attributeKey).get();
            if (null != channelProtocol) {
                return channelProtocol.getEnumProtocol();
            }
            logger.warn(" channel has attr but get null, host: {}", (Object)host);
        } else {
            logger.warn(" channel has not attr, host: {}", (Object)host);
        }
        return null;
    }

    public static String getPeerHost(ChannelHandlerContext ctx) {
        SocketChannel socketChannel = (SocketChannel)ctx.channel();
        String hostAddress = socketChannel.remoteAddress().getAddress().getHostAddress();
        int port = socketChannel.remoteAddress().getPort();
        return hostAddress + ":" + port;
    }

    public static boolean isChannelAvailable(ChannelHandlerContext ctx) {
        return null != ctx && ctx.channel().isActive() && null != ChannelVersionNegotiation.getProtocolVersion(ctx);
    }
}

