/*
 * Decompiled with CFR 0.152.
 */
package org.finra.msd.sparkfactory;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.finra.msd.containers.AppleTable;
import org.finra.msd.enums.SourceType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class SparkFactory$ {
    public static SparkFactory$ MODULE$;
    private SparkSession sparkSession;
    private SparkConf conf;

    static {
        new SparkFactory$();
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public void sparkSession_$eq(SparkSession x$1) {
        this.sparkSession = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public void conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    public void initializeSparkContext() {
        this.conf_$eq(new SparkConf().setAppName("megasparkdiff"));
        this.sparkSession_$eq(SparkSession$.MODULE$.builder().config(this.conf()).enableHiveSupport().getOrCreate());
    }

    public synchronized void initializeSparkLocalMode(String numCores, String logLevel, String defaultPartitions) {
        if (this.sparkSession() == null) {
            this.conf_$eq(new SparkConf().setAppName("megasparkdiff").setMaster(numCores).set("spark.driver.host", "localhost").set("spark.ui.enabled", "false").set("spark.sql.shuffle.partitions", defaultPartitions));
            this.sparkSession_$eq(SparkSession$.MODULE$.builder().config(this.conf()).enableHiveSupport().getOrCreate());
            this.sparkSession().sparkContext().setLogLevel(logLevel);
            return;
        }
    }

    public void initializeDataBricks(SparkSession dataBricksSparkSession) {
        this.sparkSession_$eq(dataBricksSparkSession);
    }

    public void stopSparkContext() {
        this.sparkSession().stop();
    }

    public Dataset<Row> parallelizeTextFile(String textFileLocation) {
        SparkContext qual$1 = this.sparkSession().sparkContext();
        String x$1 = textFileLocation;
        int x$2 = qual$1.textFile$default$2();
        RDD rowRDD = qual$1.textFile(x$1, x$2).map((Function1 & Serializable & scala.Serializable)row -> RowFactory.create((Object[])new Object[]{row}), ClassTag$.MODULE$.apply(Row.class));
        StructType schema = DataTypes.createStructType((StructField[])((StructField[])((Object[])new StructField[]{DataTypes.createStructField((String)"values", (DataType)DataTypes.StringType, (boolean)true)})));
        return this.sparkSession().sqlContext().createDataFrame(rowRDD, schema).toDF();
    }

    public AppleTable parallelizeTextSource(String textFileLocation, String tempViewName) {
        Dataset<Row> df = this.parallelizeTextFile(textFileLocation);
        return new AppleTable(SourceType.FILE, df, null, tempViewName);
    }

    public AppleTable parallelizeJSONSource(String jsonFileLocation, String tempViewName, String[] firstLevelElementNames, Option<String> delimiter) {
        StructType expectedSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])firstLevelElementNames)).map((Function1 & Serializable & scala.Serializable)x -> new StructField(x, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        Dataset df = this.sparkSession().sqlContext().read().schema(expectedSchema).option("multiLine", "true").format("org.apache.spark.sql.execution.datasources.msd").load(jsonFileLocation);
        df.createOrReplaceTempView(tempViewName);
        return new AppleTable(SourceType.JSON, (Dataset<Row>)df, (String)delimiter.orNull(Predef$.MODULE$.$conforms()), tempViewName);
    }

    public Option<String> parallelizeJSONSource$default$4() {
        return Option$.MODULE$.apply((Object)",");
    }

    public AppleTable parallelizeJDBCSource(String driverClassName, String jdbcUrl, String username, String password, String sqlQuery, String tempViewName, Option<String> delimiter) {
        Dataset jdbcDF = this.sparkSession().sqlContext().read().format("jdbc").option("driver", driverClassName).option("url", jdbcUrl).option("dbtable", sqlQuery).option("user", username).option("password", password).load();
        jdbcDF.createOrReplaceTempView(tempViewName);
        return new AppleTable(SourceType.JDBC, (Dataset<Row>)jdbcDF, (String)delimiter.orNull(Predef$.MODULE$.$conforms()), tempViewName);
    }

    public AppleTable parallelizeJDBCSource(String driverClassName, String jdbcUrl, String username, String password, String sqlQuery, String tempViewName, Option<String> delimiter, String partitionColumn, String lowerBound, String upperBound, String numPartitions) {
        Dataset jdbcDF = this.sparkSession().sqlContext().read().format("jdbc").option("driver", driverClassName).option("url", jdbcUrl).option("dbtable", sqlQuery).option("user", username).option("password", password).option("partitionColumn", partitionColumn).option("lowerBound", lowerBound).option("upperBound", upperBound).option("numPartitions", numPartitions).load();
        jdbcDF.createOrReplaceTempView(tempViewName);
        return new AppleTable(SourceType.JDBC, (Dataset<Row>)jdbcDF, (String)delimiter.orNull(Predef$.MODULE$.$conforms()), tempViewName);
    }

    public AppleTable parallelizeJDBCSource(String driverClassName, String jdbcUrl, String username, String password, String sqlQuery, String tempViewName) {
        return this.parallelizeJDBCSource(driverClassName, jdbcUrl, username, password, sqlQuery, tempViewName, (Option<String>)Option$.MODULE$.apply((Object)","));
    }

    public AppleTable parallelizeHiveSource(String sqlText, String tempViewName) {
        Dataset df = this.sparkSession().sql(sqlText);
        df.createOrReplaceTempView(tempViewName);
        return new AppleTable(SourceType.HIVE, (Dataset<Row>)df, ",", tempViewName);
    }

    public AppleTable parallelizeDynamoDBSource(String tableName, String tempViewName, String[] firstLevelElementNames, Option<String> delimiter, Option<String[]> selectColumns, Option<String> filter, Option<String> region, Option<String> roleArn, Option<String> readPartitions, Option<String> maxPartitionBytes, Option<String> defaultParallelism, Option<String> targetCapacity, Option<String> stronglyConsistentReads, Option<String> bytesPerRCU, Option<String> filterPushdown, Option<String> throughput) {
        StructType expectedSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])firstLevelElementNames)).map((Function1 & Serializable & scala.Serializable)x -> new StructField(x, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        scala.collection.immutable.Map options = (scala.collection.immutable.Map)((TraversableLike)((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"region"), region)}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"roleArn"), roleArn)}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"readPartitions"), readPartitions)}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxPartitionBytes"), maxPartitionBytes)}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"defaultParallelism"), defaultParallelism)}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetCapacity"), targetCapacity)}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stronglyConsistentReads"), stronglyConsistentReads)}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytesPerRCU"), bytesPerRCU)}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filterPushdown"), filterPushdown)}))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"throughput"), throughput)}))).filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SparkFactory$.$anonfun$parallelizeDynamoDBSource$2(x)))).map((Function1 & Serializable & scala.Serializable)x -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x._1()), ((Option)x._2()).get()), Map$.MODULE$.canBuildFrom());
        Dataset df = this.sparkSession().read().schema(expectedSchema).format("com.audienceproject.spark.dynamodb.msd.datasource").option("table", tableName).options((Map)options).load().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])selectColumns.getOrElse((Function0 & Serializable & scala.Serializable)() -> firstLevelElementNames))).map((Function1 & Serializable & scala.Serializable)x -> new Column(x), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
        if (filter.isDefined()) {
            df = df.filter((String)filter.get());
        }
        df.createOrReplaceTempView(tempViewName);
        return new AppleTable(SourceType.DYNAMODB, (Dataset<Row>)df, (String)delimiter.orNull(Predef$.MODULE$.$conforms()), tempViewName);
    }

    public Option<String> parallelizeDynamoDBSource$default$4() {
        return Option$.MODULE$.apply((Object)",");
    }

    public Option<String[]> parallelizeDynamoDBSource$default$5() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$6() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$7() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$8() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$9() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$10() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$11() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$12() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$13() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$14() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$15() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeDynamoDBSource$default$16() {
        return Option$.MODULE$.empty();
    }

    public AppleTable parallelizeCSVSource(String filePath, String tempViewName, Option<StructType> schemaDef, Option<String> delimiter) {
        Dataset df = null;
        df = schemaDef.isDefined() ? this.sparkSession().sqlContext().read().option("multiLine", "true").option("delimiter", (String)delimiter.get()).schema((StructType)schemaDef.get()).format("csv").load(filePath) : this.sparkSession().sqlContext().read().option("multiLine", "true").option("delimiter", (String)delimiter.get()).option("inferSchema", "true").format("csv").load(filePath);
        df.createOrReplaceTempView(tempViewName);
        return new AppleTable(SourceType.CSV, (Dataset<Row>)df, (String)delimiter.get(), tempViewName);
    }

    public Option<StructType> parallelizeCSVSource$default$3() {
        return Option$.MODULE$.empty();
    }

    public Option<String> parallelizeCSVSource$default$4() {
        return Option$.MODULE$.apply((Object)",");
    }

    public Dataset<Row> flattenDataFrame(Dataset<Row> df, String delimiter) {
        SparkSession x = this.sparkSession();
        return df.map((Function1 & Serializable & scala.Serializable)row -> row.mkString(delimiter), x.implicits().newStringEncoder()).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"values"}));
    }

    public Dataset<Row> simpleTableToSimpleJSONFormatTable(Dataset<Row> df) {
        ObjectRef expandDf = ObjectRef.create(df);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.schema().fields())).foreach((Function1 & Serializable & scala.Serializable)field -> {
            SparkFactory$.$anonfun$simpleTableToSimpleJSONFormatTable$1(expandDf, field);
            return BoxedUnit.UNIT;
        });
        return (Dataset)expandDf.elem;
    }

    public static final /* synthetic */ boolean $anonfun$parallelizeDynamoDBSource$2(Tuple2 x) {
        return ((Option)x._2()).isDefined();
    }

    public static final /* synthetic */ void $anonfun$simpleTableToSimpleJSONFormatTable$1(ObjectRef expandDf$1, StructField field) {
        DataType dataType = field.dataType();
        StringType$ stringType$ = StringType$.MODULE$;
        if (!(dataType != null ? !dataType.equals(stringType$) : stringType$ != null)) {
            expandDf$1.elem = ((Dataset)expandDf$1.elem).withColumn(field.name(), functions$.MODULE$.when(functions$.MODULE$.col(field.name()).startsWith(functions$.MODULE$.lit((Object)"[")).and(functions$.MODULE$.col(field.name()).endsWith(functions$.MODULE$.lit((Object)"]"))), (Object)functions$.MODULE$.col(field.name())).otherwise((Object)functions$.MODULE$.when(functions$.MODULE$.col(field.name()).startsWith(functions$.MODULE$.lit((Object)"{")).and(functions$.MODULE$.col(field.name()).endsWith(functions$.MODULE$.lit((Object)"}"))), (Object)functions$.MODULE$.col(field.name())).otherwise((Object)functions$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.lit((Object)"\""), functions$.MODULE$.col(field.name()), functions$.MODULE$.lit((Object)"\"")})))));
            return;
        }
    }

    private SparkFactory$() {
        MODULE$ = this;
        this.sparkSession = null;
        this.conf = null;
    }
}

