/*
 * Decompiled with CFR 0.152.
 */
package org.finra.msd.containers;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.finra.msd.util.FileUtil;

public class SourceVars {
    private String connection;
    private Map<String, String> vars = new HashMap<String, String>();
    private Map<String, String> queries = new HashMap<String, String>();

    public SourceVars(String fileName) {
        this(new File(fileName));
    }

    public SourceVars(File source) {
        List<String> fileContents = FileUtil.fileToStringList(source);
        for (String line : fileContents) {
            if ((line = line.trim().replaceAll(" +", " ")).isEmpty()) continue;
            if (line.charAt(0) == '@') {
                String dataName = line.substring(1, line.indexOf(":")).trim();
                String query = line.substring(line.indexOf(":") + 1).trim();
                this.queries.put(dataName, query);
                continue;
            }
            if (!line.contains("=")) continue;
            String key = line.substring(0, line.indexOf("=")).trim();
            String val = line.substring(line.indexOf("=") + 1).trim();
            if (key.equals("connection")) {
                this.connection = val;
                continue;
            }
            this.vars.put(key, val);
        }
    }

    public String getConnection() {
        return this.connection;
    }

    public String getVar(String key) {
        return this.vars.get(key);
    }

    public String getQuery(String dataName) {
        return this.queries.get(dataName);
    }
}

