/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.server.core.session;

import io.dropwizard.Bundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import java.io.IOException;
import java.security.Principal;
import java.util.EnumSet;
import java.util.Optional;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.profile.ProfileManager;

public class SessionAttributeBundle
implements Bundle {
    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(Environment environment) {
        environment.servlets().addFilter("SessionAttributeEnricher", Enricher.class).addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
    }

    public static class Enricher
    implements Filter {
        public void init(FilterConfig filterConfig) {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            HttpSession session = ((HttpServletRequest)request).getSession();
            Principal userPrincipal = ((HttpServletRequest)request).getUserPrincipal();
            if (userPrincipal != null) {
                session.setAttribute("UserId", (Object)userPrincipal.getName());
                J2EContext context = new J2EContext((HttpServletRequest)request, (HttpServletResponse)response);
                ProfileManager manager = new ProfileManager((WebContext)context);
                Optional profile = manager.get(true);
                profile.ifPresent(commonProfile -> session.setAttribute("UserProfile", commonProfile));
            }
            session.setAttribute("Calls", (Object)((session.getAttribute("Calls") == null ? 0 : (Integer)session.getAttribute("Calls")) + 1));
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

