/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.server.core.exceptionMappers;

import com.fasterxml.jackson.core.JsonProcessingException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.factory.Maps;
import org.finos.legend.engine.shared.core.operational.errorManagement.ExceptionTool;
import org.finos.legend.engine.shared.core.operational.logs.LoggingEventType;

public class JsonInformationExceptionMapper
implements ExceptionMapper<JsonProcessingException> {
    public Response toResponse(JsonProcessingException exception) {
        MutableMap entity = Maps.mutable.empty();
        entity.put("code", 500);
        entity.put("message", exception.getOriginalMessage());
        if (exception.getLocation() != null) {
            entity.put("location", String.format("line %d, column %d", exception.getLocation().getLineNr(), exception.getLocation().getColumnNr()));
        }
        return ExceptionTool.exceptionManager((Exception)exception, (LoggingEventType)LoggingEventType.JSON_PARSING_ERROR, null);
    }
}

