/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.server.core.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;

@Api(tags={"Server"})
@Path(value="server/v1/memory")
@Produces(value={"application/json"})
public class Memory {
    @GET
    @Path(value="gc")
    @ApiOperation(value="Performs GC")
    public Response executeGC() {
        Runtime.getRuntime().gc();
        return Response.status((int)200).type("application/json").entity((Object)"{}").build();
    }

    @GET
    @Path(value="info")
    @ApiOperation(value="Provides the server JVM memory information")
    public Response executeMemoryInfo() {
        try {
            UnifiedMap memory = UnifiedMap.newMap();
            memory.put("total", Runtime.getRuntime().totalMemory());
            memory.put("max", Runtime.getRuntime().maxMemory());
            memory.put("free", Runtime.getRuntime().freeMemory());
            return Response.status((int)200).type("application/json").entity((Object)new ObjectMapper().writeValueAsString((Object)memory)).build();
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

