/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.server.core;

import io.opentracing.util.GlobalTracer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodySpanDecorator
implements ReaderInterceptor {
    private static final int MAX_LENGTH = 10240;
    private static final Logger LOGGER = LoggerFactory.getLogger(BodySpanDecorator.class);

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        try {
            InputStream is = context.getInputStream();
            if (GlobalTracer.get() != null && GlobalTracer.get().activeSpan() != null && is != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream(10242);
                IOUtils.copyLarge((InputStream)is, (OutputStream)os, (long)0L, (long)10241L);
                String body = new String(os.toByteArray());
                if (body.length() > 10240) {
                    body = body.substring(0, 10240) + " (truncated)";
                }
                GlobalTracer.get().activeSpan().setTag("body", body);
                context.setInputStream((InputStream)new SequenceInputStream(new ByteArrayInputStream(os.toByteArray()), is));
            }
        }
        catch (IOException e) {
            LOGGER.warn("Unable to trace request body", (Throwable)e);
        }
        return context.proceed();
    }
}

