/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.forms.MultiPartBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.federecio.dropwizard.swagger.SwaggerBundle;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import io.prometheus.client.CollectorRegistry;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.commons.text.StrSubstitutor;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.ListIterate;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.finos.legend.authentication.credentialprovider.CredentialProvider;
import org.finos.legend.authentication.credentialprovider.CredentialProviderProvider;
import org.finos.legend.authentication.credentialprovider.impl.PrivateKeyCredentialProvider;
import org.finos.legend.authentication.intermediationrule.impl.EncryptedPrivateKeyFromVaultRule;
import org.finos.legend.authentication.vault.CredentialVault;
import org.finos.legend.authentication.vault.CredentialVaultProvider;
import org.finos.legend.authentication.vault.impl.EnvironmentCredentialVault;
import org.finos.legend.authentication.vault.impl.PropertiesFileCredentialVault;
import org.finos.legend.authentication.vault.impl.SystemPropertiesCredentialVault;
import org.finos.legend.connection.AuthenticationMechanism;
import org.finos.legend.connection.AuthenticationMechanismType;
import org.finos.legend.connection.ConnectionBuilder;
import org.finos.legend.connection.ConnectionFactory;
import org.finos.legend.connection.CredentialBuilder;
import org.finos.legend.connection.DatabaseSupport;
import org.finos.legend.connection.DatabaseType;
import org.finos.legend.connection.HACKY__RelationalDatabaseConnectionAdapter;
import org.finos.legend.connection.LegendEnvironment;
import org.finos.legend.connection.impl.CoreAuthenticationMechanismType;
import org.finos.legend.connection.impl.HACKY__SnowflakeConnectionAdapter;
import org.finos.legend.connection.impl.KerberosCredentialExtractor;
import org.finos.legend.connection.impl.KeyPairCredentialBuilder;
import org.finos.legend.connection.impl.RelationalDatabaseType;
import org.finos.legend.connection.impl.SnowflakeConnectionBuilder;
import org.finos.legend.connection.impl.StaticJDBCConnectionBuilder;
import org.finos.legend.connection.impl.UserPasswordCredentialBuilder;
import org.finos.legend.engine.api.analytics.BindingAnalytics;
import org.finos.legend.engine.api.analytics.ClassAnalytics;
import org.finos.legend.engine.api.analytics.DataSpaceAnalytics;
import org.finos.legend.engine.api.analytics.DiagramAnalytics;
import org.finos.legend.engine.api.analytics.FunctionAnalytics;
import org.finos.legend.engine.api.analytics.LineageAnalytics;
import org.finos.legend.engine.api.analytics.MappingAnalytics;
import org.finos.legend.engine.api.analytics.StoreEntitlementAnalytics;
import org.finos.legend.engine.application.query.api.ApplicationQuery;
import org.finos.legend.engine.application.query.configuration.ApplicationQueryConfiguration;
import org.finos.legend.engine.authentication.LegendDefaultDatabaseAuthenticationFlowProvider;
import org.finos.legend.engine.authentication.LegendDefaultDatabaseAuthenticationFlowProviderConfiguration;
import org.finos.legend.engine.authentication.provider.DatabaseAuthenticationFlowProviderConfiguration;
import org.finos.legend.engine.entitlement.services.EntitlementModelObjectMapperFactory;
import org.finos.legend.engine.entitlement.services.EntitlementServiceExtensionLoader;
import org.finos.legend.engine.external.shared.format.extension.GenerationExtension;
import org.finos.legend.engine.external.shared.format.extension.GenerationMode;
import org.finos.legend.engine.external.shared.format.generations.loaders.CodeGenerators;
import org.finos.legend.engine.external.shared.format.generations.loaders.SchemaGenerators;
import org.finos.legend.engine.external.shared.format.imports.loaders.CodeImports;
import org.finos.legend.engine.external.shared.format.imports.loaders.SchemaImports;
import org.finos.legend.engine.external.shared.format.model.api.ExternalFormats;
import org.finos.legend.engine.functionActivator.api.FunctionActivatorAPI;
import org.finos.legend.engine.functionActivator.service.FunctionActivatorService;
import org.finos.legend.engine.generation.artifact.api.ArtifactGenerationExtensionApi;
import org.finos.legend.engine.language.hostedService.api.HostedServiceService;
import org.finos.legend.engine.language.pure.compiler.api.Compile;
import org.finos.legend.engine.language.pure.grammar.api.grammarToJson.GrammarToJson;
import org.finos.legend.engine.language.pure.grammar.api.grammarToJson.TransformGrammarToJson;
import org.finos.legend.engine.language.pure.grammar.api.jsonToGrammar.JsonToGrammar;
import org.finos.legend.engine.language.pure.grammar.api.jsonToGrammar.TransformJsonToGrammar;
import org.finos.legend.engine.language.pure.grammar.api.relationalOperationElement.RelationalOperationElementGrammarToJson;
import org.finos.legend.engine.language.pure.grammar.api.relationalOperationElement.RelationalOperationElementJsonToGrammar;
import org.finos.legend.engine.language.pure.grammar.api.relationalOperationElement.TransformRelationalOperationElementGrammarToJson;
import org.finos.legend.engine.language.pure.grammar.api.relationalOperationElement.TransformRelationalOperationElementJsonToGrammar;
import org.finos.legend.engine.language.pure.modelManager.ModelLoader;
import org.finos.legend.engine.language.pure.modelManager.ModelManager;
import org.finos.legend.engine.language.pure.modelManager.sdlc.SDLCLoader;
import org.finos.legend.engine.language.pure.relational.api.relationalElement.RelationalElementAPI;
import org.finos.legend.engine.language.snowflakeApp.api.SnowflakeAppService;
import org.finos.legend.engine.plan.execution.PlanExecutor;
import org.finos.legend.engine.plan.execution.api.ExecutePlanLegacy;
import org.finos.legend.engine.plan.execution.api.ExecutePlanStrategic;
import org.finos.legend.engine.plan.execution.api.concurrent.ConcurrentExecutionNodeExecutorPoolInfo;
import org.finos.legend.engine.plan.execution.api.concurrent.ParallelGraphFetchExecutionExecutorPoolInfo;
import org.finos.legend.engine.plan.execution.concurrent.ParallelGraphFetchExecutionExecutorPool;
import org.finos.legend.engine.plan.execution.graphFetch.GraphFetchExecutionConfiguration;
import org.finos.legend.engine.plan.execution.service.api.ServiceModelingApi;
import org.finos.legend.engine.plan.execution.stores.StoreExecutor;
import org.finos.legend.engine.plan.execution.stores.StoreExecutorConfiguration;
import org.finos.legend.engine.plan.execution.stores.elasticsearch.v7.plugin.ElasticsearchV7StoreExecutor;
import org.finos.legend.engine.plan.execution.stores.elasticsearch.v7.plugin.ElasticsearchV7StoreExecutorBuilder;
import org.finos.legend.engine.plan.execution.stores.inMemory.plugin.InMemory;
import org.finos.legend.engine.plan.execution.stores.mongodb.plugin.MongoDBStoreExecutor;
import org.finos.legend.engine.plan.execution.stores.mongodb.plugin.MongoDBStoreExecutorBuilder;
import org.finos.legend.engine.plan.execution.stores.mongodb.plugin.MongoDBStoreExecutorConfiguration;
import org.finos.legend.engine.plan.execution.stores.relational.api.RelationalExecutorInformation;
import org.finos.legend.engine.plan.execution.stores.relational.config.RelationalExecutionConfiguration;
import org.finos.legend.engine.plan.execution.stores.relational.connection.api.schema.SchemaExplorationApi;
import org.finos.legend.engine.plan.execution.stores.relational.plugin.Relational;
import org.finos.legend.engine.plan.execution.stores.relational.plugin.RelationalStoreExecutor;
import org.finos.legend.engine.plan.execution.stores.service.plugin.ServiceStoreExecutionConfiguration;
import org.finos.legend.engine.plan.execution.stores.service.plugin.ServiceStoreExecutor;
import org.finos.legend.engine.plan.execution.stores.service.plugin.ServiceStoreExecutorBuilder;
import org.finos.legend.engine.plan.generation.extension.PlanGeneratorExtension;
import org.finos.legend.engine.protocol.bigqueryFunction.metamodel.BigQueryFunctionDeploymentConfiguration;
import org.finos.legend.engine.protocol.hostedService.deployment.HostedServiceDeploymentConfiguration;
import org.finos.legend.engine.protocol.pure.v1.PureProtocolObjectMapperFactory;
import org.finos.legend.engine.protocol.pure.v1.model.PureProtocol;
import org.finos.legend.engine.protocol.pure.v1.packageableElement.connection.EncryptedPrivateKeyPairAuthenticationConfiguration;
import org.finos.legend.engine.protocol.pure.v1.packageableElement.connection.UserPasswordAuthenticationConfiguration;
import org.finos.legend.engine.protocol.snowflakeApp.deployment.SnowflakeAppDeploymentConfiguration;
import org.finos.legend.engine.pure.code.core.PureCoreExtensionLoader;
import org.finos.legend.engine.query.graphQL.api.debug.GraphQLDebug;
import org.finos.legend.engine.query.graphQL.api.execute.GraphQLExecute;
import org.finos.legend.engine.query.graphQL.api.grammar.GraphQLGrammar;
import org.finos.legend.engine.query.pure.api.Execute;
import org.finos.legend.engine.query.sql.api.SQLExecutor;
import org.finos.legend.engine.query.sql.api.execute.SqlExecute;
import org.finos.legend.engine.query.sql.api.grammar.SqlGrammar;
import org.finos.legend.engine.query.sql.providers.LegendServiceSQLSourceProvider;
import org.finos.legend.engine.query.sql.providers.RelationalStoreSQLSourceProvider;
import org.finos.legend.engine.query.sql.providers.core.SQLSourceProvider;
import org.finos.legend.engine.query.sql.providers.shared.FunctionSQLSourceProvider;
import org.finos.legend.engine.query.sql.providers.shared.project.ProjectCoordinateLoader;
import org.finos.legend.engine.server.ServerConfiguration;
import org.finos.legend.engine.server.core.ServerShared;
import org.finos.legend.engine.server.core.api.CurrentUser;
import org.finos.legend.engine.server.core.api.Info;
import org.finos.legend.engine.server.core.api.Memory;
import org.finos.legend.engine.server.core.bundles.ErrorHandlingBundle;
import org.finos.legend.engine.server.core.exceptionMappers.CatchAllExceptionMapper;
import org.finos.legend.engine.server.core.exceptionMappers.JsonInformationExceptionMapper;
import org.finos.legend.engine.server.core.session.SessionAttributeBundle;
import org.finos.legend.engine.server.core.session.SessionTracker;
import org.finos.legend.engine.server.core.session.StoreExecutableManagerSessionListener;
import org.finos.legend.engine.server.core.session.api.SessionInfo;
import org.finos.legend.engine.shared.core.ObjectMapperFactory;
import org.finos.legend.engine.shared.core.deployment.DeploymentStateAndVersions;
import org.finos.legend.engine.shared.core.operational.http.InflateInterceptor;
import org.finos.legend.engine.shared.core.url.EngineUrlStreamHandlerFactory;
import org.finos.legend.engine.shared.core.vault.PropertyVaultConfiguration;
import org.finos.legend.engine.shared.core.vault.Vault;
import org.finos.legend.engine.shared.core.vault.VaultConfiguration;
import org.finos.legend.engine.shared.core.vault.VaultFactory;
import org.finos.legend.engine.testData.generation.api.TestDataGeneration;
import org.finos.legend.engine.testable.api.Testable;
import org.finos.legend.pure.m3.execution.ExecutionSupport;
import org.finos.legend.server.pac4j.LegendPac4jBundle;
import org.finos.legend.server.shared.bundles.ChainFixingFilterHandler;
import org.finos.legend.server.shared.bundles.HostnameHeaderBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server<T extends ServerConfiguration>
extends Application<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Server.class);
    protected RelationalStoreExecutor relationalStoreExecutor;
    private Environment environment;

    public static void main(String[] args) throws Exception {
        String[] stringArray;
        EngineUrlStreamHandlerFactory.initialize();
        Server server = new Server();
        if (args.length == 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "server";
            stringArray = stringArray2;
            stringArray2[1] = "legend-engine-config/legend-engine-server/src/test/resources/org/finos/legend/engine/server/test/userTestConfig.json";
        } else {
            stringArray = args;
        }
        server.run(stringArray);
    }

    public void initialize(Bootstrap<T> bootstrap) {
        bootstrap.addBundle((Bundle)new AssetsBundle("/web", "/", "legend_index.html"));
        bootstrap.addBundle((ConfiguredBundle)new SwaggerBundle<T>(){

            protected SwaggerBundleConfiguration getSwaggerBundleConfiguration(T configuration) {
                return ((ServerConfiguration)((Object)configuration)).swagger;
            }
        });
        bootstrap.addBundle((Bundle)new HostnameHeaderBundle());
        bootstrap.addBundle((ConfiguredBundle)new LegendPac4jBundle(serverConfiguration -> serverConfiguration.pac4j));
        bootstrap.addBundle((Bundle)new SessionAttributeBundle());
        bootstrap.addBundle((Bundle)new MultiPartBundle());
        bootstrap.addBundle(new ErrorHandlingBundle<ServerConfiguration>(serverConfiguration -> serverConfiguration.errorhandlingconfiguration));
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StrSubstitutor)new EnvironmentVariableSubstitutor(true)));
        PureProtocolObjectMapperFactory.withPureProtocolExtensions((ObjectMapper)bootstrap.getObjectMapper());
        EntitlementModelObjectMapperFactory.withEntitlementModelExtensions((ObjectMapper)bootstrap.getObjectMapper());
        VaultFactory.withVaultConfigurationExtensions((ObjectMapper)bootstrap.getObjectMapper());
        ObjectMapperFactory.withStandardConfigurations((ObjectMapper)bootstrap.getObjectMapper());
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(LegendDefaultDatabaseAuthenticationFlowProviderConfiguration.class, "legendDefault")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(HostedServiceDeploymentConfiguration.class, "hostedServiceConfig")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(SnowflakeAppDeploymentConfiguration.class, "snowflakeAppConfig")});
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(BigQueryFunctionDeploymentConfiguration.class, "snowflakeAppConfig")});
    }

    public CredentialProviderProvider configureCredentialProviders(List<VaultConfiguration> vaultConfigurations) {
        Properties properties = this.buildVaultProperties(vaultConfigurations);
        CredentialVaultProvider credentialVaultProvider = CredentialVaultProvider.builder().with((CredentialVault)new PropertiesFileCredentialVault(properties)).build();
        PrivateKeyCredentialProvider privateKeyCredentialProvider = new PrivateKeyCredentialProvider(Lists.immutable.of((Object)new EncryptedPrivateKeyFromVaultRule(credentialVaultProvider)).castToList());
        CredentialProviderProvider credentialProviderProvider = CredentialProviderProvider.builder().with((CredentialProvider)privateKeyCredentialProvider).build();
        return credentialProviderProvider;
    }

    private Properties buildVaultProperties(List<VaultConfiguration> vaultConfigurations) {
        Properties properties = new Properties();
        if (vaultConfigurations == null) {
            return properties;
        }
        MutableList propertyVaultConfigurations = ListIterate.select(vaultConfigurations, (Predicate & Serializable)v -> v instanceof PropertyVaultConfiguration);
        propertyVaultConfigurations.forEach((Procedure & Serializable)vaultConfiguration -> {
            PropertyVaultConfiguration propertyVaultConfiguration = (PropertyVaultConfiguration)vaultConfiguration;
            try {
                properties.load(new FileInputStream(propertyVaultConfiguration.location));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return properties;
    }

    public void run(T serverConfiguration, Environment environment) {
        PlanExecutor planExecutor;
        this.loadVaults(((ServerConfiguration)((Object)serverConfiguration)).vaults);
        this.environment = environment;
        DeploymentStateAndVersions.DEPLOYMENT_MODE = ((ServerConfiguration)((Object)serverConfiguration)).deployment.mode;
        SDLCLoader sdlcLoader = new SDLCLoader(((ServerConfiguration)((Object)serverConfiguration)).metadataserver, null);
        ModelManager modelManager = new ModelManager(((ServerConfiguration)((Object)serverConfiguration)).deployment.mode, new ModelLoader[]{sdlcLoader});
        ChainFixingFilterHandler.apply((ServletContextHandler)environment.getApplicationContext(), ((ServerConfiguration)((Object)serverConfiguration)).filterPriorities);
        CredentialProviderProvider credentialProviderProvider = this.configureCredentialProviders(((ServerConfiguration)((Object)serverConfiguration)).vaults);
        RelationalExecutionConfiguration relationalExecution = ((ServerConfiguration)((Object)serverConfiguration)).relationalexecution;
        relationalExecution.setCredentialProviderProvider(credentialProviderProvider);
        if (relationalExecution.getFlowProviderClass() == null || relationalExecution.getFlowProviderConfiguration() == null) {
            relationalExecution.setFlowProviderClass(LegendDefaultDatabaseAuthenticationFlowProvider.class);
            relationalExecution.setFlowProviderConfiguration((DatabaseAuthenticationFlowProviderConfiguration)new LegendDefaultDatabaseAuthenticationFlowProviderConfiguration());
        }
        relationalExecution.setConnectionFactory(this.setupConnectionFactory(((ServerConfiguration)((Object)serverConfiguration)).vaults));
        relationalExecution.setRelationalDatabaseConnectionAdapters((List)Lists.mutable.of((Object[])new HACKY__RelationalDatabaseConnectionAdapter[]{new HACKY__SnowflakeConnectionAdapter.WithKeyPair()}));
        this.relationalStoreExecutor = (RelationalStoreExecutor)Relational.build((RelationalExecutionConfiguration)((ServerConfiguration)((Object)serverConfiguration)).relationalexecution);
        ServiceStoreExecutionConfiguration serviceStoreExecutionConfiguration = ServiceStoreExecutionConfiguration.builder().withCredentialProviderProvider(credentialProviderProvider).build();
        ServiceStoreExecutor serviceStoreExecutor = (ServiceStoreExecutor)new ServiceStoreExecutorBuilder().build((StoreExecutorConfiguration)serviceStoreExecutionConfiguration);
        MongoDBStoreExecutorConfiguration mongoDBExecutorConfiguration = MongoDBStoreExecutorConfiguration.newInstance().withCredentialProviderProvider(credentialProviderProvider).build();
        MongoDBStoreExecutor mongoDBStoreExecutor = (MongoDBStoreExecutor)new MongoDBStoreExecutorBuilder().build((StoreExecutorConfiguration)mongoDBExecutorConfiguration);
        ElasticsearchV7StoreExecutor elasticsearchV7StoreExecutor = (ElasticsearchV7StoreExecutor)new ElasticsearchV7StoreExecutorBuilder().build();
        ParallelGraphFetchExecutionExecutorPool parallelGraphFetchExecutionExecutorPool = null;
        if (((ServerConfiguration)((Object)serverConfiguration)).graphFetchExecutionConfiguration != null) {
            GraphFetchExecutionConfiguration graphFetchExecutionConfiguration = ((ServerConfiguration)((Object)serverConfiguration)).graphFetchExecutionConfiguration;
            planExecutor = PlanExecutor.newPlanExecutor((GraphFetchExecutionConfiguration)graphFetchExecutionConfiguration, (StoreExecutor[])new StoreExecutor[]{this.relationalStoreExecutor, elasticsearchV7StoreExecutor, serviceStoreExecutor, mongoDBStoreExecutor, InMemory.build()});
            if (graphFetchExecutionConfiguration.canExecuteInParallel()) {
                parallelGraphFetchExecutionExecutorPool = new ParallelGraphFetchExecutionExecutorPool(graphFetchExecutionConfiguration.getParallelGraphFetchExecutionConfig(), "thread-pool for parallel graphFetch execution");
                planExecutor.injectGraphFetchExecutionNodeExecutorPool(parallelGraphFetchExecutionExecutorPool);
            }
        } else {
            planExecutor = PlanExecutor.newPlanExecutor((StoreExecutor[])new StoreExecutor[]{this.relationalStoreExecutor, elasticsearchV7StoreExecutor, serviceStoreExecutor, mongoDBStoreExecutor, InMemory.build()});
        }
        SessionTracker sessionTracker = new SessionTracker();
        SessionHandler sessionHandler = new SessionHandler();
        StoreExecutableManagerSessionListener storeExecutableManagerSessionListener = new StoreExecutableManagerSessionListener();
        if (((ServerConfiguration)((Object)serverConfiguration)).sessionCookie != null) {
            sessionHandler.setSessionCookie(((ServerConfiguration)((Object)serverConfiguration)).sessionCookie);
        }
        environment.servlets().setSessionHandler(sessionHandler);
        environment.servlets().addServletListeners(new EventListener[]{sessionTracker});
        environment.servlets().addServletListeners(new EventListener[]{storeExecutableManagerSessionListener});
        environment.jersey().register((Object)new SessionInfo(sessionTracker));
        environment.jersey().setUrlPattern("/api/*");
        ServerShared.registerSwagger(environment, ((ServerConfiguration)((Object)serverConfiguration)).swagger);
        environment.jersey().register((Object)new Info(((ServerConfiguration)((Object)serverConfiguration)).deployment, ((ServerConfiguration)((Object)serverConfiguration)).opentracing));
        environment.jersey().register((Object)new CurrentUser());
        environment.jersey().register((Object)new Memory());
        environment.jersey().register((Object)new RelationalExecutorInformation());
        environment.jersey().register((Object)new ConcurrentExecutionNodeExecutorPoolInfo(Collections.emptyList()));
        environment.jersey().register((Object)new ParallelGraphFetchExecutionExecutorPoolInfo(parallelGraphFetchExecutionExecutorPool));
        environment.jersey().register((Object)new PureProtocol());
        environment.jersey().register((Object)new GrammarToJson());
        environment.jersey().register((Object)new JsonToGrammar());
        environment.jersey().register((Object)new RelationalOperationElementGrammarToJson());
        environment.jersey().register((Object)new RelationalOperationElementJsonToGrammar());
        environment.jersey().register((Object)new TransformGrammarToJson());
        environment.jersey().register((Object)new TransformJsonToGrammar());
        environment.jersey().register((Object)new TransformRelationalOperationElementGrammarToJson());
        environment.jersey().register((Object)new TransformRelationalOperationElementJsonToGrammar());
        environment.jersey().register((Object)new SchemaExplorationApi(modelManager, this.relationalStoreExecutor));
        environment.jersey().register((Object)new RelationalElementAPI(((ServerConfiguration)((Object)serverConfiguration)).deployment.mode, this.relationalStoreExecutor));
        environment.jersey().register((resourceInfo, context) -> context.register((Object)new InflateInterceptor()));
        environment.jersey().register((Object)new Compile(modelManager));
        MutableList genExtensions = (MutableList)Iterate.addAllTo(ServiceLoader.load(GenerationExtension.class), (Collection)Lists.mutable.empty());
        environment.jersey().register((Object)new CodeGenerators(modelManager, (List)genExtensions.select((Predicate & Serializable)p -> p.getMode() == GenerationMode.Code).collect(GenerationExtension::getGenerationDescription).select(Objects::nonNull)));
        environment.jersey().register((Object)new CodeImports(modelManager, (List)genExtensions.select((Predicate & Serializable)p -> p.getMode() == GenerationMode.Code).collect(GenerationExtension::getImportDescription).select(Objects::nonNull)));
        environment.jersey().register((Object)new SchemaGenerators(modelManager, (List)genExtensions.select((Predicate & Serializable)p -> p.getMode() == GenerationMode.Schema).collect(GenerationExtension::getGenerationDescription).select(Objects::nonNull)));
        environment.jersey().register((Object)new SchemaImports(modelManager, (List)genExtensions.select((Predicate & Serializable)p -> p.getMode() == GenerationMode.Schema).collect(GenerationExtension::getImportDescription).select(Objects::nonNull)));
        genExtensions.forEach((Procedure & Serializable)p -> environment.jersey().register(p.getService(modelManager)));
        MutableList generatorExtensions = Lists.mutable.withAll(ServiceLoader.load(PlanGeneratorExtension.class));
        Function & Serializable routerExtensions = (Function & Serializable)pureModel -> PureCoreExtensionLoader.extensions().flatCollect((Function & Serializable)e -> e.extraPureCoreExtensions((ExecutionSupport)pureModel.getExecutionSupport()));
        environment.jersey().register((Object)new Execute(modelManager, planExecutor, (Function)routerExtensions, (Iterable)generatorExtensions.flatCollect(PlanGeneratorExtension::getExtraPlanTransformers)));
        environment.jersey().register((Object)new ExecutePlanStrategic(planExecutor));
        environment.jersey().register((Object)new ExecutePlanLegacy(planExecutor));
        environment.jersey().register((Object)new FunctionActivatorAPI(modelManager, (List)Lists.mutable.empty(), Lists.mutable.with((Object[])new FunctionActivatorService[]{new SnowflakeAppService(planExecutor), new HostedServiceService()}), (Function)routerExtensions));
        environment.jersey().register((Object)new GraphQLGrammar());
        environment.jersey().register((Object)new GraphQLExecute(modelManager, planExecutor, ((ServerConfiguration)((Object)serverConfiguration)).metadataserver, (java.util.function.Function)routerExtensions, (Iterable)generatorExtensions.flatCollect(PlanGeneratorExtension::getExtraPlanTransformers)));
        environment.jersey().register((Object)new GraphQLDebug(modelManager, ((ServerConfiguration)((Object)serverConfiguration)).metadataserver, (java.util.function.Function)routerExtensions));
        ProjectCoordinateLoader projectCoordinateLoader = new ProjectCoordinateLoader(modelManager, ((ServerConfiguration)((Object)serverConfiguration)).metadataserver.getSdlc());
        environment.jersey().register((Object)new SqlExecute(new SQLExecutor(modelManager, planExecutor, (Function)routerExtensions, (List)FastList.newListWith((Object[])new SQLSourceProvider[]{new RelationalStoreSQLSourceProvider(projectCoordinateLoader), new FunctionSQLSourceProvider(projectCoordinateLoader), new LegendServiceSQLSourceProvider(projectCoordinateLoader)}), (Iterable)generatorExtensions.flatCollect(PlanGeneratorExtension::getExtraPlanTransformers))));
        environment.jersey().register((Object)new SqlGrammar());
        environment.jersey().register((Object)new ServiceModelingApi(modelManager, ((ServerConfiguration)((Object)serverConfiguration)).deployment.mode, planExecutor));
        environment.jersey().register((Object)new ApplicationQuery(ApplicationQueryConfiguration.getMongoClient()));
        environment.jersey().register((Object)new JsonInformationExceptionMapper());
        environment.jersey().register((Object)new CatchAllExceptionMapper());
        environment.jersey().register((Object)new ExternalFormats(modelManager));
        environment.jersey().register((Object)new ArtifactGenerationExtensionApi(modelManager));
        List entitlementServiceExtensions = EntitlementServiceExtensionLoader.extensions();
        environment.jersey().register((Object)new MappingAnalytics(modelManager));
        environment.jersey().register((Object)new ClassAnalytics(modelManager));
        environment.jersey().register((Object)new FunctionAnalytics(modelManager));
        environment.jersey().register((Object)new BindingAnalytics(modelManager));
        environment.jersey().register((Object)new DiagramAnalytics(modelManager));
        environment.jersey().register((Object)new DataSpaceAnalytics(modelManager, generatorExtensions, entitlementServiceExtensions));
        environment.jersey().register((Object)new LineageAnalytics(modelManager));
        environment.jersey().register((Object)new StoreEntitlementAnalytics(modelManager, entitlementServiceExtensions));
        environment.jersey().register((Object)new Testable(modelManager));
        environment.jersey().register((Object)new TestDataGeneration(modelManager));
        this.enableCors(environment, (ServerConfiguration)((Object)serverConfiguration));
    }

    private ConnectionFactory setupConnectionFactory(List<VaultConfiguration> vaultConfigurations) {
        LegendEnvironment environment = LegendEnvironment.builder().vaults(new CredentialVault[]{new SystemPropertiesCredentialVault(), new EnvironmentCredentialVault(), new PropertiesFileCredentialVault(this.buildVaultProperties(vaultConfigurations))}).databaseSupports(new DatabaseSupport[]{DatabaseSupport.builder().type((DatabaseType)RelationalDatabaseType.POSTGRES).authenticationMechanisms(new AuthenticationMechanism[]{AuthenticationMechanism.builder().type((AuthenticationMechanismType)CoreAuthenticationMechanismType.USER_PASSWORD).authenticationConfigurationTypes(new Class[]{UserPasswordAuthenticationConfiguration.class}).build()}).build(), DatabaseSupport.builder().type((DatabaseType)RelationalDatabaseType.SNOWFLAKE).authenticationMechanisms(new AuthenticationMechanism[]{AuthenticationMechanism.builder().type((AuthenticationMechanismType)CoreAuthenticationMechanismType.KEY_PAIR).authenticationConfigurationTypes(new Class[]{EncryptedPrivateKeyPairAuthenticationConfiguration.class}).build()}).build()}).build();
        return ConnectionFactory.builder().environment(environment).credentialBuilders(new CredentialBuilder[]{new KerberosCredentialExtractor(), new UserPasswordCredentialBuilder(), new KeyPairCredentialBuilder()}).connectionBuilders(new ConnectionBuilder[]{new StaticJDBCConnectionBuilder.WithPlaintextUsernamePassword(), new SnowflakeConnectionBuilder.WithKeyPair()}).build();
    }

    private void loadVaults(List<VaultConfiguration> vaultConfigurations) {
        if (vaultConfigurations != null) {
            ListIterate.forEach(vaultConfigurations, (Procedure & Serializable)v -> Vault.INSTANCE.registerImplementation(VaultFactory.generateVaultImplementationFromConfiguration((VaultConfiguration)v)));
        }
    }

    public void shutDown() throws Exception {
        this.environment.getApplicationContext().getServer().stop();
        CollectorRegistry.defaultRegistry.clear();
    }

    private void enableCors(Environment environment, ServerConfiguration configuration) {
        FilterRegistration.Dynamic corsFilter = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        corsFilter.setInitParameter("allowedMethods", "GET,PUT,POST,DELETE,OPTIONS");
        corsFilter.setInitParameter("allowedOrigins", "*");
        corsFilter.setInitParameter("allowedTimingOrigins", "*");
        if (configuration.cors != null && configuration.cors.getAllowedHeaders() != null) {
            corsFilter.setInitParameter("allowedHeaders", LazyIterate.adapt((Iterable)configuration.cors.getAllowedHeaders()).makeString(","));
        } else {
            corsFilter.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin,Access-Control-Allow-Credentials,x-b3-parentspanid,x-b3-sampled,x-b3-spanid,x-b3-traceid");
        }
        corsFilter.setInitParameter("chainPreflight", "false");
        corsFilter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"*"});
    }
}

