/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.server.core.session;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Collection;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.SetIterable;
import org.eclipse.collections.impl.factory.Sets;
import org.finos.legend.engine.server.core.session.SessionInfo;
import org.pac4j.core.profile.CommonProfile;

public class SessionTracker
implements HttpSessionListener {
    public static final String ATTR_USER_ID = "UserId";
    public static final String ATTR_USER_PROFILE = "UserProfile";
    public static final String ATTR_CALLS = "Calls";
    private MutableSet<HttpSession> sessions = Sets.mutable.empty();

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        this.sessions.add((Object)httpSessionEvent.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        this.sessions.removeAll((Collection)this.sessions.select((Predicate & Serializable)s -> s.getId().equals(httpSessionEvent.getSession().getId())));
    }

    public SetIterable<SessionInfo> getSessionsInfo(boolean includeProfile) {
        return this.sessions.collectIf((Predicate & Serializable)s -> s.getAttribute(ATTR_USER_ID) != null, (Function & Serializable)s -> new SessionInfo(s.getCreationTime(), s.getLastAccessedTime(), (String)s.getAttribute(ATTR_USER_ID), (Integer)s.getAttribute(ATTR_CALLS), includeProfile ? (CommonProfile)s.getAttribute(ATTR_USER_PROFILE) : null));
    }

    public String toJSON(boolean includeProfile) {
        try {
            return new ObjectMapper().writeValueAsString((Object)this.getSessionsInfo(includeProfile).toList());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

