/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import io.dropwizard.Application;
import io.dropwizard.Bundle;
import io.dropwizard.ConfiguredBundle;
import io.dropwizard.assets.AssetsBundle;
import io.dropwizard.configuration.ConfigurationSourceProvider;
import io.dropwizard.configuration.EnvironmentVariableSubstitutor;
import io.dropwizard.configuration.SubstitutingSourceProvider;
import io.dropwizard.forms.MultiPartBundle;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.federecio.dropwizard.swagger.SwaggerBundle;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import io.prometheus.client.CollectorRegistry;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import javax.servlet.DispatcherType;
import javax.servlet.FilterRegistration;
import org.apache.commons.text.StrSubstitutor;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.ListIterate;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlets.CrossOriginFilter;
import org.finos.legend.engine.api.analytics.DataSpaceAnalytics;
import org.finos.legend.engine.api.analytics.DiagramAnalytics;
import org.finos.legend.engine.api.analytics.LineageAnalytics;
import org.finos.legend.engine.api.analytics.MappingAnalytics;
import org.finos.legend.engine.application.query.api.ApplicationQuery;
import org.finos.legend.engine.application.query.configuration.ApplicationQueryConfiguration;
import org.finos.legend.engine.authentication.LegendDefaultDatabaseAuthenticationFlowProviderConfiguration;
import org.finos.legend.engine.external.shared.format.extension.GenerationExtension;
import org.finos.legend.engine.external.shared.format.extension.GenerationMode;
import org.finos.legend.engine.external.shared.format.generations.loaders.CodeGenerators;
import org.finos.legend.engine.external.shared.format.generations.loaders.SchemaGenerators;
import org.finos.legend.engine.external.shared.format.imports.loaders.CodeImports;
import org.finos.legend.engine.external.shared.format.imports.loaders.SchemaImports;
import org.finos.legend.engine.external.shared.format.model.api.ExternalFormats;
import org.finos.legend.engine.language.pure.compiler.api.Compile;
import org.finos.legend.engine.language.pure.grammar.api.grammarToJson.GrammarToJson;
import org.finos.legend.engine.language.pure.grammar.api.grammarToJson.TransformGrammarToJson;
import org.finos.legend.engine.language.pure.grammar.api.jsonToGrammar.JsonToGrammar;
import org.finos.legend.engine.language.pure.grammar.api.jsonToGrammar.TransformJsonToGrammar;
import org.finos.legend.engine.language.pure.grammar.api.relationalOperationElement.RelationalOperationElementGrammarToJson;
import org.finos.legend.engine.language.pure.grammar.api.relationalOperationElement.RelationalOperationElementJsonToGrammar;
import org.finos.legend.engine.language.pure.grammar.api.relationalOperationElement.TransformRelationalOperationElementGrammarToJson;
import org.finos.legend.engine.language.pure.grammar.api.relationalOperationElement.TransformRelationalOperationElementJsonToGrammar;
import org.finos.legend.engine.language.pure.modelManager.ModelLoader;
import org.finos.legend.engine.language.pure.modelManager.ModelManager;
import org.finos.legend.engine.language.pure.modelManager.sdlc.SDLCLoader;
import org.finos.legend.engine.plan.execution.PlanExecutor;
import org.finos.legend.engine.plan.execution.api.ExecutePlanLegacy;
import org.finos.legend.engine.plan.execution.api.ExecutePlanStrategic;
import org.finos.legend.engine.plan.execution.service.api.ServiceModelingApi;
import org.finos.legend.engine.plan.execution.stores.StoreExecutor;
import org.finos.legend.engine.plan.execution.stores.inMemory.plugin.InMemory;
import org.finos.legend.engine.plan.execution.stores.relational.api.RelationalExecutorInformation;
import org.finos.legend.engine.plan.execution.stores.relational.config.RelationalExecutionConfiguration;
import org.finos.legend.engine.plan.execution.stores.relational.connection.api.schema.SchemaExplorationApi;
import org.finos.legend.engine.plan.execution.stores.relational.plugin.Relational;
import org.finos.legend.engine.plan.execution.stores.relational.plugin.RelationalStoreExecutor;
import org.finos.legend.engine.plan.execution.stores.service.plugin.ServiceStore;
import org.finos.legend.engine.plan.generation.extension.PlanGeneratorExtension;
import org.finos.legend.engine.protocol.pure.v1.PureProtocolObjectMapperFactory;
import org.finos.legend.engine.query.graphQL.api.debug.GraphQLDebug;
import org.finos.legend.engine.query.graphQL.api.execute.GraphQLExecute;
import org.finos.legend.engine.query.graphQL.api.grammar.GraphQLGrammar;
import org.finos.legend.engine.query.pure.api.Execute;
import org.finos.legend.engine.query.sql.api.execute.SqlExecute;
import org.finos.legend.engine.query.sql.api.grammar.SqlGrammar;
import org.finos.legend.engine.server.ServerConfiguration;
import org.finos.legend.engine.server.core.ServerShared;
import org.finos.legend.engine.server.core.api.CurrentUser;
import org.finos.legend.engine.server.core.api.Info;
import org.finos.legend.engine.server.core.api.Memory;
import org.finos.legend.engine.server.core.bundles.ErrorHandlingBundle;
import org.finos.legend.engine.server.core.exceptionMappers.CatchAllExceptionMapper;
import org.finos.legend.engine.server.core.exceptionMappers.JsonInformationExceptionMapper;
import org.finos.legend.engine.server.core.session.SessionAttributeBundle;
import org.finos.legend.engine.server.core.session.SessionTracker;
import org.finos.legend.engine.server.core.session.api.SessionInfo;
import org.finos.legend.engine.shared.core.ObjectMapperFactory;
import org.finos.legend.engine.shared.core.deployment.DeploymentStateAndVersions;
import org.finos.legend.engine.shared.core.operational.http.InflateInterceptor;
import org.finos.legend.engine.shared.core.url.EngineUrlStreamHandlerFactory;
import org.finos.legend.engine.shared.core.vault.Vault;
import org.finos.legend.engine.shared.core.vault.VaultConfiguration;
import org.finos.legend.engine.shared.core.vault.VaultFactory;
import org.finos.legend.engine.testable.api.Testable;
import org.finos.legend.server.pac4j.LegendPac4jBundle;
import org.finos.legend.server.shared.bundles.ChainFixingFilterHandler;
import org.finos.legend.server.shared.bundles.HostnameHeaderBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server<T extends ServerConfiguration>
extends Application<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Alloy Execution Server");
    protected RelationalStoreExecutor relationalStoreExecutor;
    private Environment environment;

    public static void main(String[] args) throws Exception {
        String[] stringArray;
        EngineUrlStreamHandlerFactory.initialize();
        Server server = new Server();
        if (args.length == 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "server";
            stringArray = stringArray2;
            stringArray2[1] = "legend-engine-server/src/test/resources/org/finos/legend/engine/server/test/userTestConfig.json";
        } else {
            stringArray = args;
        }
        server.run(stringArray);
    }

    public void initialize(Bootstrap<T> bootstrap) {
        bootstrap.addBundle((Bundle)new AssetsBundle("/web", "/", "legend_index.html"));
        bootstrap.addBundle((ConfiguredBundle)new SwaggerBundle<T>(){

            protected SwaggerBundleConfiguration getSwaggerBundleConfiguration(T configuration) {
                return ((ServerConfiguration)((Object)configuration)).swagger;
            }
        });
        bootstrap.addBundle((Bundle)new HostnameHeaderBundle());
        bootstrap.addBundle((ConfiguredBundle)new LegendPac4jBundle(serverConfiguration -> serverConfiguration.pac4j));
        bootstrap.addBundle((Bundle)new SessionAttributeBundle());
        bootstrap.addBundle((Bundle)new MultiPartBundle());
        bootstrap.addBundle(new ErrorHandlingBundle<ServerConfiguration>(serverConfiguration -> serverConfiguration.errorhandlingconfiguration));
        bootstrap.setConfigurationSourceProvider((ConfigurationSourceProvider)new SubstitutingSourceProvider(bootstrap.getConfigurationSourceProvider(), (StrSubstitutor)new EnvironmentVariableSubstitutor(true)));
        PureProtocolObjectMapperFactory.withPureProtocolExtensions((ObjectMapper)bootstrap.getObjectMapper());
        VaultFactory.withVaultConfigurationExtensions((ObjectMapper)bootstrap.getObjectMapper());
        ObjectMapperFactory.withStandardConfigurations((ObjectMapper)bootstrap.getObjectMapper());
        bootstrap.getObjectMapper().registerSubtypes(new NamedType[]{new NamedType(LegendDefaultDatabaseAuthenticationFlowProviderConfiguration.class, "legendDefault")});
    }

    public void run(T serverConfiguration, Environment environment) {
        this.loadVaults(((ServerConfiguration)((Object)serverConfiguration)).vaults);
        this.environment = environment;
        DeploymentStateAndVersions.DEPLOYMENT_MODE = ((ServerConfiguration)((Object)serverConfiguration)).deployment.mode;
        SDLCLoader sdlcLoader = new SDLCLoader(((ServerConfiguration)((Object)serverConfiguration)).metadataserver, null);
        ModelManager modelManager = new ModelManager(((ServerConfiguration)((Object)serverConfiguration)).deployment.mode, new ModelLoader[]{sdlcLoader});
        ChainFixingFilterHandler.apply((ServletContextHandler)environment.getApplicationContext(), ((ServerConfiguration)((Object)serverConfiguration)).filterPriorities);
        this.relationalStoreExecutor = (RelationalStoreExecutor)Relational.build((RelationalExecutionConfiguration)((ServerConfiguration)((Object)serverConfiguration)).relationalexecution);
        PlanExecutor planExecutor = PlanExecutor.newPlanExecutor((StoreExecutor[])new StoreExecutor[]{this.relationalStoreExecutor, ServiceStore.build(), InMemory.build()});
        SessionTracker sessionTracker = new SessionTracker();
        SessionHandler sessionHandler = new SessionHandler();
        if (((ServerConfiguration)((Object)serverConfiguration)).sessionCookie != null) {
            sessionHandler.setSessionCookie(((ServerConfiguration)((Object)serverConfiguration)).sessionCookie);
        }
        environment.servlets().setSessionHandler(sessionHandler);
        environment.servlets().addServletListeners(new EventListener[]{sessionTracker});
        environment.jersey().register((Object)new SessionInfo(sessionTracker));
        environment.jersey().setUrlPattern("/api/*");
        ServerShared.registerSwagger(environment, ((ServerConfiguration)((Object)serverConfiguration)).swagger);
        environment.jersey().register((Object)new Info(((ServerConfiguration)((Object)serverConfiguration)).deployment, ((ServerConfiguration)((Object)serverConfiguration)).opentracing));
        environment.jersey().register((Object)new CurrentUser());
        environment.jersey().register((Object)new Memory());
        environment.jersey().register((Object)new RelationalExecutorInformation());
        environment.jersey().register((Object)new GrammarToJson());
        environment.jersey().register((Object)new JsonToGrammar());
        environment.jersey().register((Object)new RelationalOperationElementGrammarToJson());
        environment.jersey().register((Object)new RelationalOperationElementJsonToGrammar());
        environment.jersey().register((Object)new TransformGrammarToJson());
        environment.jersey().register((Object)new TransformJsonToGrammar());
        environment.jersey().register((Object)new TransformRelationalOperationElementGrammarToJson());
        environment.jersey().register((Object)new TransformRelationalOperationElementJsonToGrammar());
        environment.jersey().register((Object)new SchemaExplorationApi(modelManager, this.relationalStoreExecutor));
        environment.jersey().register((resourceInfo, context) -> context.register((Object)new InflateInterceptor()));
        environment.jersey().register((Object)new Compile(modelManager));
        MutableList genExtensions = (MutableList)Iterate.addAllTo(ServiceLoader.load(GenerationExtension.class), (Collection)Lists.mutable.empty());
        environment.jersey().register((Object)new CodeGenerators(modelManager, (List)genExtensions.select((Predicate & Serializable)p -> p.getMode() == GenerationMode.Code).collect(GenerationExtension::getGenerationDescription).select(Objects::nonNull)));
        environment.jersey().register((Object)new CodeImports(modelManager, (List)genExtensions.select((Predicate & Serializable)p -> p.getMode() == GenerationMode.Code).collect(GenerationExtension::getImportDescription).select(Objects::nonNull)));
        environment.jersey().register((Object)new SchemaGenerators(modelManager, (List)genExtensions.select((Predicate & Serializable)p -> p.getMode() == GenerationMode.Schema).collect(GenerationExtension::getGenerationDescription).select(Objects::nonNull)));
        environment.jersey().register((Object)new SchemaImports(modelManager, (List)genExtensions.select((Predicate & Serializable)p -> p.getMode() == GenerationMode.Schema).collect(GenerationExtension::getImportDescription).select(Objects::nonNull)));
        genExtensions.forEach((Procedure & Serializable)p -> environment.jersey().register(p.getService(modelManager)));
        MutableList generatorExtensions = Lists.mutable.withAll(ServiceLoader.load(PlanGeneratorExtension.class));
        Function & Serializable routerExtensions = (Function & Serializable)pureModel -> generatorExtensions.flatCollect((Function & Serializable)e -> e.getExtraExtensions(pureModel));
        environment.jersey().register((Object)new Execute(modelManager, planExecutor, (Function)routerExtensions, generatorExtensions.flatCollect(PlanGeneratorExtension::getExtraPlanTransformers)));
        environment.jersey().register((Object)new ExecutePlanStrategic(planExecutor));
        environment.jersey().register((Object)new ExecutePlanLegacy(planExecutor));
        environment.jersey().register((Object)new GraphQLGrammar());
        environment.jersey().register((Object)new GraphQLExecute(modelManager, planExecutor, ((ServerConfiguration)((Object)serverConfiguration)).metadataserver, (java.util.function.Function)routerExtensions, generatorExtensions.flatCollect(PlanGeneratorExtension::getExtraPlanTransformers)));
        environment.jersey().register((Object)new GraphQLDebug(modelManager, ((ServerConfiguration)((Object)serverConfiguration)).metadataserver, (java.util.function.Function)routerExtensions));
        environment.jersey().register((Object)new SqlExecute(modelManager, planExecutor, (Function)routerExtensions, generatorExtensions.flatCollect(PlanGeneratorExtension::getExtraPlanTransformers), ((ServerConfiguration)((Object)serverConfiguration)).metadataserver, ((ServerConfiguration)((Object)serverConfiguration)).deployment.mode));
        environment.jersey().register((Object)new SqlGrammar());
        environment.jersey().register((Object)new ServiceModelingApi(modelManager, ((ServerConfiguration)((Object)serverConfiguration)).deployment.mode));
        environment.jersey().register((Object)new ApplicationQuery(ApplicationQueryConfiguration.getMongoClient()));
        environment.jersey().register((Object)new JsonInformationExceptionMapper());
        environment.jersey().register((Object)new CatchAllExceptionMapper());
        environment.jersey().register((Object)new ExternalFormats(modelManager));
        environment.jersey().register((Object)new MappingAnalytics(modelManager));
        environment.jersey().register((Object)new DiagramAnalytics(modelManager));
        environment.jersey().register((Object)new DataSpaceAnalytics(modelManager));
        environment.jersey().register((Object)new LineageAnalytics(modelManager));
        environment.jersey().register((Object)new Testable(modelManager));
        this.enableCors(environment);
    }

    private void loadVaults(List<VaultConfiguration> vaultConfigurations) {
        if (vaultConfigurations != null) {
            ListIterate.forEach(vaultConfigurations, (Procedure & Serializable)v -> Vault.INSTANCE.registerImplementation(VaultFactory.generateVaultImplementationFromConfiguration((VaultConfiguration)v)));
        }
    }

    public void shutDown() throws Exception {
        this.environment.getApplicationContext().getServer().stop();
        CollectorRegistry.defaultRegistry.clear();
    }

    private void enableCors(Environment environment) {
        FilterRegistration.Dynamic corsFilter = environment.servlets().addFilter("CORS", CrossOriginFilter.class);
        corsFilter.setInitParameter("allowedMethods", "GET,PUT,POST,DELETE,OPTIONS");
        corsFilter.setInitParameter("allowedOrigins", "*");
        corsFilter.setInitParameter("allowedTimingOrigins", "*");
        corsFilter.setInitParameter("allowedHeaders", "X-Requested-With,Content-Type,Accept,Origin,Access-Control-Allow-Credentials,x-b3-parentspanid,x-b3-sampled,x-b3-spanid,x-b3-traceid");
        corsFilter.setInitParameter("chainPreflight", "false");
        corsFilter.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"*"});
    }
}

