/*
 * Decompiled with CFR 0.152.
 */
package org.finos.legend.engine.server.core.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.net.InetAddress;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.finos.legend.engine.server.core.configuration.DeploymentConfiguration;
import org.finos.legend.engine.server.core.configuration.OpenTracingConfiguration;
import org.finos.legend.engine.shared.core.deployment.DeploymentStateAndVersions;
import org.finos.legend.engine.shared.core.deployment.DeploymentVersionInfo;
import org.finos.legend.pure.m3.serialization.filesystem.usercodestorage.classpath.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Server"})
@Path(value="server/v1")
@Produces(value={"application/json"})
public class Info {
    private String message;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Alloy Execution Server");

    public Info(DeploymentConfiguration deploymentConfiguration, OpenTracingConfiguration openTracingConfiguration) {
        this(deploymentConfiguration, openTracingConfiguration, null);
    }

    public Info(DeploymentConfiguration deploymentConfiguration, OpenTracingConfiguration openTracingConfiguration, Map<String, DeploymentVersionInfo> extraDeploymentInformation) {
        try {
            ObjectMapper m = new ObjectMapper();
            String hostAddress = InetAddress.getLocalHost().getCanonicalHostName();
            String addedInfo = "";
            if (extraDeploymentInformation != null) {
                String extraJson = m.writeValueAsString(extraDeploymentInformation);
                addedInfo = "," + extraJson.substring(1, extraJson.length() - 1);
            }
            this.message = "{\"info\":   {     \"server\":         {             \"host\":\"" + hostAddress + "\",             \"startTime\":\"" + new Date() + "\",             \"timeZone\":\"" + TimeZone.getDefault().getID() + "\"         },     \"legendSDLC\":" + m.writeValueAsString((Object)DeploymentStateAndVersions.sdlc) + ",     \"deployment\":        {          \"mode\" : \"" + deploymentConfiguration.mode + "\"        }" + addedInfo + "   },\"zipkin\":   {      \"url\":\"" + openTracingConfiguration.getZipkin() + "\"   },\"pure\":   {       \"platform\":\"" + Version.PLATFORM + "\",       \"server\":\"" + Version.SERVER + "\",       \"model\":\"" + Version.MODEL + "\"   }}";
        }
        catch (Exception e) {
            LOGGER.error("Error creating info message", (Throwable)e);
            this.message = "{}";
        }
    }

    @GET
    @Path(value="info")
    @ApiOperation(value="Provides server build and dependency information")
    public Response executePureGet() {
        return Response.status((int)200).type("application/json").entity((Object)this.message).build();
    }
}

