/*
 * Decompiled with CFR 0.152.
 */
package org.fhir.ucum.definitions;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.fhir.ucum.BaseUnit;
import org.fhir.ucum.Decimal;
import org.fhir.ucum.DefinedUnit;
import org.fhir.ucum.Prefix;
import org.fhir.ucum.UcumException;
import org.fhir.ucum.UcumModel;
import org.fhir.ucum.Value;
import org.fhir.ucum.definitions.DefinitionsProvider;
import org.fhir.ucum.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlDefinitionsParser
implements DefinitionsProvider {
    @Override
    public UcumModel parse(String filename) throws UcumException {
        try {
            return this.parse(new FileInputStream(new File(filename)));
        }
        catch (Exception e) {
            throw new UcumException(e);
        }
    }

    @Override
    public UcumModel parse(InputStream stream) throws UcumException {
        try {
            Document doc = XmlUtils.parseDOM(stream);
            Element element = doc.getDocumentElement();
            if (!element.getNodeName().equals("root")) {
                throw new UcumException("Unable to process XML document: expected 'root' but found '" + element.getNodeName() + "'");
            }
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss' 'Z");
            Date date = fmt.parse(element.getAttribute("revision-date").substring(7, 32));
            UcumModel root = new UcumModel(element.getAttribute("version"), element.getAttribute("revision"), date);
            Element focus = XmlUtils.getFirstChild(element);
            while (focus != null) {
                if (focus.getNodeName().equals("prefix")) {
                    root.getPrefixes().add(this.parsePrefix(focus));
                } else if (focus.getNodeName().equals("base-unit")) {
                    root.getBaseUnits().add(this.parseBaseUnit(focus));
                } else if (focus.getNodeName().equals("unit")) {
                    root.getDefinedUnits().add(this.parseUnit(focus));
                } else {
                    throw new UcumException("unknown element name " + focus.getNodeName());
                }
                focus = XmlUtils.getNextSibling(focus);
            }
            return root;
        }
        catch (Exception e) {
            throw new UcumException(e);
        }
    }

    private DefinedUnit parseUnit(Element x) throws IOException, UcumException {
        DefinedUnit unit = new DefinedUnit(x.getAttribute("Code"), x.getAttribute("CODE"));
        unit.setMetric("yes".equals(x.getAttribute("isMetric")));
        unit.setSpecial("yes".equals(x.getAttribute("isSpecial")));
        unit.setClass_(x.getAttribute("class"));
        for (Element e : XmlUtils.getNamedChildren(x, "name")) {
            unit.getNames().add(e.getTextContent());
        }
        unit.setPrintSymbol(XmlUtils.getNamedChildText(x, "printSymbol"));
        unit.setProperty(XmlUtils.getNamedChildText(x, "property"));
        unit.setValue(this.parseValue(XmlUtils.getNamedChild(x, "value"), "unit " + unit.getCode()));
        return unit;
    }

    private Value parseValue(Element x, String context) throws UcumException, IOException {
        Decimal val = null;
        if (x.getAttribute("value") != null) {
            try {
                val = x.getAttribute("value").contains(".") ? new Decimal(x.getAttribute("value"), 24) : new Decimal(x.getAttribute("value"));
            }
            catch (NumberFormatException e) {
                throw new UcumException("Error reading " + context + ": " + e.getMessage());
            }
        }
        Value value = new Value(x.getAttribute("Unit"), x.getAttribute("UNIT"), val);
        value.setText(x.getTextContent());
        return value;
    }

    private BaseUnit parseBaseUnit(Element x) throws IOException {
        BaseUnit base = new BaseUnit(x.getAttribute("Code"), x.getAttribute("CODE"));
        base.setDim(x.getAttribute("dim").charAt(0));
        for (Element e : XmlUtils.getNamedChildren(x, "name")) {
            base.getNames().add(e.getTextContent());
        }
        base.setPrintSymbol(XmlUtils.getNamedChildText(x, "printSymbol"));
        base.setProperty(XmlUtils.getNamedChildText(x, "property"));
        return base;
    }

    private Prefix parsePrefix(Element x) throws IOException, UcumException {
        Prefix prefix = new Prefix(x.getAttribute("Code"), x.getAttribute("CODE"));
        for (Element e : XmlUtils.getNamedChildren(x, "name")) {
            prefix.getNames().add(e.getTextContent());
        }
        prefix.setPrintSymbol(XmlUtils.getNamedChildText(x, "printSymbol"));
        Element value = XmlUtils.getNamedChild(x, "value");
        prefix.setValue(new Decimal(value.getAttribute("value"), 24));
        return prefix;
    }
}

