/*
 * Decompiled with CFR 0.152.
 */
package org.fhir.ucum;

import java.util.ArrayList;
import java.util.List;
import org.fhir.ucum.BaseUnit;
import org.fhir.ucum.Decimal;
import org.fhir.ucum.UcumException;

public class Canonical {
    private Decimal value;
    private List<CanonicalUnit> units = new ArrayList<CanonicalUnit>();

    public Canonical(Decimal value) {
        this.value = value;
    }

    public Decimal getValue() {
        return this.value;
    }

    public List<CanonicalUnit> getUnits() {
        return this.units;
    }

    public void setValue(Decimal value) {
        this.value = value;
    }

    public void multiplyValue(Decimal multiplicand) {
        this.value = this.value.multiply(multiplicand);
    }

    public void multiplyValue(int multiplicand) {
        this.value = this.value.multiply(new Decimal(multiplicand));
    }

    public void divideValue(Decimal divisor) throws UcumException {
        this.value = this.value.divide(divisor);
    }

    public void divideValue(int divisor) throws UcumException {
        this.value = this.value.divide(new Decimal(divisor));
    }

    public static class CanonicalUnit {
        private BaseUnit base;
        private int exponent;

        protected CanonicalUnit(BaseUnit base, int exponent) {
            this.base = base;
            this.exponent = exponent;
        }

        public BaseUnit getBase() {
            return this.base;
        }

        public int getExponent() {
            return this.exponent;
        }

        public void setExponent(int exponent) {
            this.exponent = exponent;
        }
    }
}

