/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.api.security;

import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.ff4j.web.ApiConfig;
import org.ff4j.web.api.security.FF4jSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FF4jAuthenticationFilter
implements ContainerRequestFilter {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static ApiConfig apiConfig = null;

    public void filter(ContainerRequestContext containerRequest) throws IOException {
        String method = containerRequest.getMethod();
        String path = containerRequest.getUriInfo().getPath();
        this.log.debug("Entering security filter for <" + path + ">");
        if (method.equals("GET") && (path.equals("application.wadl") || path.equals("application.wadl/xsd0.xsd"))) {
            this.log.info("Accessing schema and wadl ok");
            return;
        }
        String auth = containerRequest.getHeaderString("Authorization");
        if (auth == null) {
            this.handleUnAuthorized("<p>'authorization' parameter is required in header  for authentication (HTTP-Basic or ApiKey)</p>");
        }
        if (auth.contains("apiKey")) {
            auth = auth.replaceFirst("apiKey=", "");
            if (!apiConfig.getApiKeys().contains(auth)) {
                this.handleUnAuthorized("The api key provided '" + auth + "' is invalid ");
            }
            Set perms = (Set)apiConfig.getPermissions().get(auth);
            FF4jSecurityContext sc = new FF4jSecurityContext(auth, "APIKEY", perms);
            containerRequest.setSecurityContext((SecurityContext)sc);
            this.log.info("Client successfully logged with an ApiKey");
            return;
        }
        if (auth.toUpperCase().contains("BASIC")) {
            String expectedPassword;
            byte[] decodedBytes = Base64.getDecoder().decode(auth.replaceFirst("[B|b]asic ", "").getBytes());
            String[] lap = new String(decodedBytes).split(":", 2);
            if (lap == null || lap.length != 2) {
                this.handleUnAuthorized("Invalid BASIC Token, cannot parse");
            }
            if ((expectedPassword = (String)apiConfig.getUsers().get(lap[0])) == null || !lap[1].equals(expectedPassword)) {
                this.handleUnAuthorized("<p>Invalid username or password.</p>");
            }
            Set perms = (Set)apiConfig.getPermissions().get(lap[0]);
            this.log.info(Arrays.toString(perms.toArray()));
            FF4jSecurityContext sc = new FF4jSecurityContext(lap[0], "BASIC", perms);
            containerRequest.setSecurityContext((SecurityContext)sc);
            this.log.info("Client successfully logged with a user/pasword pair ");
            return;
        }
        this.handleUnAuthorized("Cannot parse authorisation header attribute, valid are basic and apiKey");
    }

    private void handleUnAuthorized(String message) {
        StringBuilder msg = new StringBuilder("<p style=\"color:#880000\">");
        msg.append("<H1>ERROR HTTP 401 : Unauthorized</H1>");
        msg.append("<p>" + message + "</p>");
        this.log.error("Authentication error :" + message);
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)msg.toString()).type(MediaType.TEXT_HTML_TYPE).build());
    }

    public static ApiConfig getApiConfig() {
        return apiConfig;
    }

    public static void setApiConfig(ApiConfig apiConfig) {
        FF4jAuthenticationFilter.apiConfig = apiConfig;
    }
}

