/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.activation.MimetypesFileTypeMap;
import org.ff4j.FF4j;
import org.ff4j.web.controller.AbstractController;
import org.ff4j.web.utils.FileUtils;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.WebContext;

public class StaticResourceController
extends AbstractController {
    private Map<String, String> cssFiles = new HashMap<String, String>();
    private Map<String, String> jsFiles = new HashMap<String, String>();
    private Map<String, byte[]> fontFiles = new HashMap<String, byte[]>();
    private Map<String, byte[]> images = new HashMap<String, byte[]>();

    public StaticResourceController(FF4j ff4j, TemplateEngine te) {
        super(ff4j, null, te);
    }

    @Override
    public void post(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws IOException {
        LOGGER.warn("Nothing to implement in POST");
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws IOException {
        String[] pathParts;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "/";
        }
        if ((pathParts = pathInfo.split("/")).length >= 3) {
            String resourceType = pathParts[2];
            String resourceName = pathParts[pathParts.length - 1];
            if ("css".equalsIgnoreCase(resourceType)) {
                this.serveCss(res, pathInfo, resourceName);
            } else if ("js".equalsIgnoreCase(resourceType)) {
                this.serveJs(res, pathInfo, resourceName);
            } else if ("font".equalsIgnoreCase(resourceType)) {
                this.serveFont(res, pathInfo, resourceName);
            } else if ("img".equalsIgnoreCase(resourceType)) {
                this.serveImage(res, pathInfo, resourceName);
            } else {
                this.notFound(res, pathInfo);
            }
        } else {
            this.notFound(res, pathInfo);
        }
    }

    private void serveCss(HttpServletResponse res, String pathInfo, String resourceName) throws IOException {
        try {
            if (!this.cssFiles.containsKey(resourceName)) {
                this.cssFiles.put(resourceName, FileUtils.loadFileAsString(pathInfo));
            }
            res.setContentType("text/css");
            res.getWriter().println(this.cssFiles.get(resourceName));
        }
        catch (FileNotFoundException fnf) {
            this.notFound(res, "CSS File " + pathInfo + "(" + resourceName + ")");
        }
    }

    private void serveFont(HttpServletResponse res, String pathInfo, String resourceName) throws IOException {
        try {
            if (!this.fontFiles.containsKey(resourceName)) {
                this.fontFiles.put(resourceName, FileUtils.loadFileAsByteArray(pathInfo));
            }
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
            res.setContentType(mimetypesFileTypeMap.getContentType(resourceName));
            res.getOutputStream().write(this.fontFiles.get(resourceName));
        }
        catch (FileNotFoundException fnf) {
            this.notFound(res, "fontFiles  " + pathInfo + "(" + resourceName + ")");
        }
    }

    private void serveJs(HttpServletResponse res, String pathInfo, String resourceName) throws IOException {
        try {
            if (!this.jsFiles.containsKey(resourceName)) {
                this.jsFiles.put(resourceName, FileUtils.loadFileAsString(pathInfo));
            }
            res.setContentType("application/javascript");
            res.getWriter().println(this.jsFiles.get(resourceName));
        }
        catch (FileNotFoundException fnf) {
            this.notFound(res, "CSS File " + pathInfo + "(" + resourceName + ")");
        }
    }

    private void serveImage(HttpServletResponse res, String pathInfo, String resourceName) throws IOException {
        try {
            if (!this.images.containsKey(resourceName)) {
                this.images.put(resourceName, FileUtils.loadFileAsByteArray(pathInfo));
            }
            MimetypesFileTypeMap mimetypesFileTypeMap = new MimetypesFileTypeMap();
            res.setContentType(mimetypesFileTypeMap.getContentType(resourceName));
            res.getOutputStream().write(this.images.get(resourceName));
        }
        catch (FileNotFoundException fnf) {
            this.notFound(res, pathInfo);
        }
    }

    private void notFound(HttpServletResponse res, String pathInfo) throws IOException {
        res.setContentType("text/plain");
        res.getWriter().println("Ressource [" + pathInfo + "] not found");
    }
}

