/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.controller;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.util.Calendar;
import java.util.Locale;
import org.ff4j.FF4j;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.conf.FF4jConfiguration;
import org.ff4j.conf.XmlConfig;
import org.ff4j.conf.XmlParser;
import org.ff4j.parser.properties.PropertiesParser;
import org.ff4j.parser.yaml.YamlParser;
import org.ff4j.web.bean.HomeBean;
import org.ff4j.web.controller.AbstractController;
import org.ff4j.web.embedded.ConsoleOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.WebContext;
import org.thymeleaf.util.StringUtils;

public class HomeController
extends AbstractController {
    public static final Logger LOGGER = LoggerFactory.getLogger(HomeController.class);
    private static final String VIEW_HOME = "home";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";

    public HomeController(FF4j ff4j, TemplateEngine te) {
        super(ff4j, VIEW_HOME, te);
    }

    private boolean isMultipartContent(String contentType) {
        return !StringUtils.isEmpty((String)contentType) && contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART_FORM_DATA);
    }

    private static FF4jConfiguration getFf4jConfiguration(Part part, String filename) throws IOException {
        XmlConfig ff4jConfig = null;
        if (filename.toLowerCase().endsWith("xml")) {
            ff4jConfig = new XmlParser().parseConfigurationFile(part.getInputStream());
        } else if (filename.toLowerCase().endsWith("yml") || filename.toLowerCase().endsWith("yaml")) {
            ff4jConfig = new YamlParser().parseConfigurationFile(part.getInputStream());
        } else if (filename.toLowerCase().endsWith("properties")) {
            ff4jConfig = new PropertiesParser().parseConfigurationFile(part.getInputStream());
        }
        return ff4jConfig;
    }

    @Override
    public void post(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws Exception {
        Object msg = null;
        String msgType = "success";
        String operation = req.getParameter("op");
        if (this.isMultipartContent(req.getContentType())) {
            for (Part part : req.getParts()) {
                if ("op".equalsIgnoreCase(part.getName())) {
                    LOGGER.info("Processing action : " + part.getName());
                    continue;
                }
                if (!"flipFile".equalsIgnoreCase(part.getName())) continue;
                String filename = part.getSubmittedFileName();
                LOGGER.info("Processing flipfile : " + filename);
                try {
                    FF4jConfiguration ff4jConfig = HomeController.getFf4jConfiguration(part, filename);
                    if (ff4jConfig != null) {
                        ConsoleOperations.importFile(this.getFf4j(), ff4jConfig);
                        msg = "The file <b>" + filename + "</b> has been successfully imported";
                        continue;
                    }
                    msgType = "error";
                    msg = "Invalid FILE, must be XML, YAML or PROPERTIES files";
                }
                catch (RuntimeException re) {
                    msgType = "error";
                    msg = "Cannot Import Config:" + re.getMessage();
                    break;
                }
            }
            ctx.setVariable("msgType", (Object)msgType);
            ctx.setVariable("msgInfo", msg);
            this.get(req, res, ctx);
        } else if ("createSchema".equalsIgnoreCase(operation)) {
            try {
                this.getFf4j().createSchema();
                msg = "Schema has been created in DB (if required).";
                ctx.setVariable("msgType", (Object)msgType);
                ctx.setVariable("msgInfo", msg);
                this.get(req, res, ctx);
            }
            catch (RuntimeException re) {
                ctx.setVariable("msgType", (Object)"error");
                ctx.setVariable("msgInfo", (Object)("Cannot create Schema:" + re.getMessage()));
                ctx.setVariable("TITLE", (Object)"Home");
                ctx.setVariable("today", (Object)Calendar.getInstance());
                ctx.setVariable("homebean", (Object)new HomeBean());
            }
        } else if ("clearCache".equalsIgnoreCase(operation)) {
            FF4jCacheProxy cacheProxy = this.getFf4j().getCacheProxy();
            if (cacheProxy != null) {
                cacheProxy.getCacheManager().clearFeatures();
                cacheProxy.getCacheManager().clearProperties();
                msg = "Cache Cleared!";
            } else {
                msg = "Cache not present: it cannot be cleared!";
            }
            ctx.setVariable("msgType", (Object)msgType);
            ctx.setVariable("msgInfo", msg);
            this.get(req, res, ctx);
        }
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws Exception {
        ctx.setVariable("TITLE", (Object)"Home");
        ctx.setVariable("today", (Object)Calendar.getInstance());
        HomeBean hb = new HomeBean();
        try {
            hb = new HomeBean(this.ff4j);
        }
        catch (RuntimeException e) {
            LOGGER.error("Cannot read store", (Throwable)e);
            ctx.setVariable("msgType", (Object)"error");
            ctx.setVariable("msgInfo", (Object)("Cannot read store:" + e.getMessage()));
        }
        ctx.setVariable("homebean", (Object)hb);
    }
}

