/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.ff4j.web.FF4jServlet;
import org.ff4j.web.controller.AbstractController;

public class FF4jDispatcherServlet
extends FF4jServlet {
    private static final long serialVersionUID = -3982043895954284269L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (this.redirectUrlWithoutSlash(req, res)) {
            return;
        }
        res.setCharacterEncoding("UTF-8");
        String targetView = this.getTargetView(req);
        if ("static".equals(targetView) && req.getPathInfo().length() > 1) {
            this.staticResourceController.get(req, res, null);
        } else if ("api".equals(targetView)) {
            this.operationsController.get(req, res, null);
        } else if (!mapOfControllers.containsKey(targetView)) {
            targetView = "404";
        } else {
            res.setContentType("text/html");
            ((AbstractController)mapOfControllers.get(targetView)).get(req, res);
        }
    }

    private boolean redirectUrlWithoutSlash(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getServletPath().equals(req.getRequestURI())) {
            res.sendRedirect(String.valueOf(req.getRequestURL()) + "/");
            return true;
        }
        return false;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        res.setCharacterEncoding("UTF-8");
        String targetView = this.getTargetView(req);
        if ("api".equals(targetView)) {
            this.operationsController.post(req, res, null);
        } else if (mapOfControllers.containsKey(targetView)) {
            res.setContentType("text/html");
            ((AbstractController)mapOfControllers.get(targetView)).post(req, res);
        } else {
            targetView = "404";
        }
    }

    private String getTargetView(HttpServletRequest req) {
        String[] pathParts;
        String targetView = "home";
        String pathInfo = req.getPathInfo();
        if (pathInfo != null && (pathParts = pathInfo.split("/")).length > 1) {
            targetView = pathParts[1];
        }
        return targetView;
    }
}

