/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.web.controller;

import java.util.Calendar;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.ff4j.FF4j;
import org.ff4j.cache.FF4jCacheProxy;
import org.ff4j.conf.FF4jConfiguration;
import org.ff4j.conf.XmlConfig;
import org.ff4j.conf.XmlParser;
import org.ff4j.parser.properties.PropertiesParser;
import org.ff4j.parser.yaml.YamlParser;
import org.ff4j.web.bean.HomeBean;
import org.ff4j.web.controller.AbstractController;
import org.ff4j.web.embedded.ConsoleOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.WebContext;

public class HomeController
extends AbstractController {
    public static final Logger LOGGER = LoggerFactory.getLogger(HomeController.class);
    private static final String VIEW_HOME = "home";

    public HomeController(FF4j ff4j, TemplateEngine te) {
        super(ff4j, VIEW_HOME, te);
    }

    @Override
    public void post(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws Exception {
        String msg = null;
        String msgType = "success";
        String operation = req.getParameter("op");
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
            List items = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory()).parseRequest(req);
            for (FileItem item : items) {
                if (item.isFormField()) {
                    if (!"op".equalsIgnoreCase(item.getFieldName())) continue;
                    LOGGER.info("Processing action : " + item.getString());
                    continue;
                }
                if (!"flipFile".equalsIgnoreCase(item.getFieldName())) continue;
                String filename = FilenameUtils.getName((String)item.getName());
                try {
                    XmlConfig ff4jConfig = null;
                    if (filename.toLowerCase().endsWith("xml")) {
                        ff4jConfig = new XmlParser().parseConfigurationFile(item.getInputStream());
                    } else if (filename.toLowerCase().endsWith("yml") || filename.toLowerCase().endsWith("yaml")) {
                        ff4jConfig = new YamlParser().parseConfigurationFile(item.getInputStream());
                    } else if (filename.toLowerCase().endsWith("properties")) {
                        ff4jConfig = new PropertiesParser().parseConfigurationFile(item.getInputStream());
                    }
                    if (ff4jConfig != null) {
                        ConsoleOperations.importFile(this.getFf4j(), (FF4jConfiguration)ff4jConfig);
                        msg = "The file <b>" + filename + "</b> has been successfully imported";
                        continue;
                    }
                    msgType = "error";
                    msg = "Invalid FILE, must be XML, YAML or PROPERTIES files";
                }
                catch (RuntimeException re) {
                    msgType = "error";
                    msg = "Cannot Import Config:" + re.getMessage();
                    break;
                }
            }
            ctx.setVariable("msgType", (Object)msgType);
            ctx.setVariable("msgInfo", (Object)msg);
            this.get(req, res, ctx);
        } else if ("createSchema".equalsIgnoreCase(operation)) {
            try {
                this.getFf4j().createSchema();
                msg = "Schema has been created in DB (if required).";
                ctx.setVariable("msgType", (Object)msgType);
                ctx.setVariable("msgInfo", (Object)msg);
                this.get(req, res, ctx);
            }
            catch (RuntimeException re) {
                ctx.setVariable("msgType", (Object)"error");
                ctx.setVariable("msgInfo", (Object)("Cannot create Schema:" + re.getMessage()));
                ctx.setVariable("TITLE", (Object)"Home");
                ctx.setVariable("today", (Object)Calendar.getInstance());
                ctx.setVariable("homebean", (Object)new HomeBean());
            }
        } else if ("clearCache".equalsIgnoreCase(operation)) {
            FF4jCacheProxy cacheProxy = this.getFf4j().getCacheProxy();
            if (cacheProxy != null) {
                cacheProxy.getCacheManager().clearFeatures();
                cacheProxy.getCacheManager().clearProperties();
                msg = "Cache Cleared!";
            } else {
                msg = "Cache not present: it cannot be cleared!";
            }
            ctx.setVariable("msgType", (Object)msgType);
            ctx.setVariable("msgInfo", (Object)msg);
            this.get(req, res, ctx);
        }
    }

    @Override
    public void get(HttpServletRequest req, HttpServletResponse res, WebContext ctx) throws Exception {
        ctx.setVariable("TITLE", (Object)"Home");
        ctx.setVariable("today", (Object)Calendar.getInstance());
        HomeBean hb = new HomeBean();
        try {
            hb = new HomeBean(this.ff4j);
        }
        catch (RuntimeException e) {
            LOGGER.error("Cannot read store", (Throwable)e);
            ctx.setVariable("msgType", (Object)"error");
            ctx.setVariable("msgInfo", (Object)("Cannot read store:" + e.getMessage()));
        }
        ctx.setVariable("homebean", (Object)hb);
    }
}

