/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.utils.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.property.Property;
import org.ff4j.property.util.PropertyFactory;
import org.ff4j.utils.MappingUtil;

public class FeatureJsonParser {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private FeatureJsonParser() {
    }

    public static Feature parseFeature(String json) {
        try {
            return FeatureJsonParser.parseFeatureMap((Map)objectMapper.readValue(json, HashMap.class));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot parse json as Feature " + json, e);
        }
    }

    public static Set<String> parsePermissions(String json) {
        if (json == null) {
            return null;
        }
        try {
            return (Set)objectMapper.readValue(json, Set.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse json list");
        }
    }

    private static Feature parseFeatureMap(Map<String, Object> fMap) {
        Feature f = new Feature((String)fMap.get("uid"));
        f.setEnable(((Boolean)fMap.get("enable")).booleanValue());
        f.setDescription((String)fMap.get("description"));
        f.setGroup((String)fMap.get("group"));
        ArrayList perm = (ArrayList)fMap.get("permissions");
        f.setPermissions(new HashSet());
        if (perm != null) {
            f.getPermissions().addAll(perm);
        }
        f.setFlippingStrategy(FeatureJsonParser.parseFlipStrategy(f.getUid(), (LinkedHashMap)fMap.get("flippingStrategy")));
        Map propertyMap = (Map)fMap.get("customProperties");
        f.setCustomProperties(FeatureJsonParser.parseCustomProperties(propertyMap));
        return f;
    }

    private static Map<String, Property<?>> parseCustomProperties(Map<String, Object> customPTag) {
        LinkedHashMap myProperties = new LinkedHashMap();
        if (null != customPTag && !customPTag.isEmpty()) {
            for (Object property : customPTag.values()) {
                HashMap propertyJson = (HashMap)property;
                String propertyName = (String)propertyJson.get("name");
                String propertyVal = String.valueOf(propertyJson.get("value"));
                String propertyType = (String)propertyJson.get("type");
                Property ap = PropertyFactory.createProperty((String)propertyName, (String)propertyType, (String)propertyVal);
                List listOfFixedValue = (List)propertyJson.get("fixedValues");
                FeatureJsonParser.addFixedValuesToProperty(ap, listOfFixedValue);
                myProperties.put(ap.getName(), ap);
            }
        }
        return myProperties;
    }

    private static void addFixedValuesToProperty(Property<?> ap, List<Object> listOfFixedValue) {
        if (listOfFixedValue != null) {
            for (Object v : listOfFixedValue) {
                ap.add2FixedValueFromString(String.valueOf(v));
            }
            if (ap.getFixedValues() != null && !ap.getFixedValues().contains(ap.getValue())) {
                throw new IllegalArgumentException("Cannot create property <" + ap.getName() + "> invalid value <" + String.valueOf(ap.getValue()) + "> expected one of " + String.valueOf(ap.getFixedValues()));
            }
        }
    }

    public static String featureArrayToJson(Feature[] features) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (features != null) {
            boolean first = true;
            for (Feature feature : features) {
                sb.append(first ? "" : ",");
                sb.append(feature.toJson());
                first = false;
            }
        }
        sb.append("]");
        return sb.toString();
    }

    public static FlippingStrategy parseFlipStrategyAsJson(String uid, String json) {
        if (null == json || "".equals(json)) {
            return null;
        }
        try {
            return FeatureJsonParser.parseFlipStrategy(uid, (HashMap)objectMapper.readValue(json, HashMap.class));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse JSON " + json, e);
        }
    }

    public static FlippingStrategy parseFlipStrategy(String uid, Map<String, Object> flipMap) {
        if (null == flipMap || flipMap.isEmpty()) {
            return null;
        }
        String classType = (String)flipMap.get("type");
        HashMap initparams = (HashMap)flipMap.get("initParams");
        return MappingUtil.instanceFlippingStrategy((String)uid, (String)classType, (Map)initparams);
    }

    public static Feature[] parseFeatureArray(String json) {
        if (null == json || "".equals(json)) {
            return null;
        }
        try {
            List flipMap = (List)objectMapper.readValue(json, List.class);
            Feature[] fArray = new Feature[flipMap.size()];
            int idx = 0;
            for (LinkedHashMap ll : flipMap) {
                fArray[idx++] = FeatureJsonParser.parseFeatureMap(ll);
            }
            return fArray;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse JSON " + json, e);
        }
    }
}

