/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.api.sync.RedisSetCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.redis.RedisKeysBuilder;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.PropertyJsonParser;

public class PropertyStoreRedisLettuce
extends AbstractPropertyStore {
    private final RedisKeyCommands<String, String> redisKeyCommands;
    private final RedisStringCommands<String, String> redisStringCommands;
    private final RedisSetCommands<String, String> redisSetCommands;
    private final RedisKeysBuilder keyBuilder;

    public PropertyStoreRedisLettuce(RedisClient redisClient) {
        this(redisClient, new RedisKeysBuilder());
    }

    public PropertyStoreRedisLettuce(RedisClient redisClient, RedisKeysBuilder keyBuilder) {
        this.redisKeyCommands = redisClient.connect().sync();
        this.redisStringCommands = redisClient.connect().sync();
        this.redisSetCommands = redisClient.connect().sync();
        this.keyBuilder = keyBuilder;
    }

    public PropertyStoreRedisLettuce(RedisClusterClient redisClusterClient) {
        this(redisClusterClient, new RedisKeysBuilder());
    }

    public PropertyStoreRedisLettuce(RedisClusterClient redisClusterClient, RedisKeysBuilder keyBuilder) {
        this.redisKeyCommands = redisClusterClient.connect().sync();
        this.redisStringCommands = redisClusterClient.connect().sync();
        this.redisSetCommands = redisClusterClient.connect().sync();
        this.keyBuilder = keyBuilder;
    }

    public boolean existProperty(String name) {
        Util.assertParamHasLength((String)name, (String)"PropertyName identifier");
        String key = this.keyBuilder.getKeyProperty(name);
        return 1L == this.redisKeyCommands.exists((Object[])new String[]{key});
    }

    public <T> void createProperty(Property<T> prop) {
        Util.assertNotNull((Object[])new Object[]{prop});
        if (this.existProperty(prop.getName())) {
            throw new PropertyAlreadyExistException(prop.getName());
        }
        this.redisSetCommands.sadd((Object)this.keyBuilder.getKeyPropertyMap(), (Object[])new String[]{prop.getName()});
        this.redisStringCommands.set((Object)this.keyBuilder.getKeyProperty(prop.getName()), (Object)prop.toJson());
        this.redisKeyCommands.persist((Object)this.keyBuilder.getKeyProperty(prop.getName()));
    }

    public Property<?> readProperty(String name) {
        this.assertPropertyExist(name);
        String key = this.keyBuilder.getKeyProperty(name);
        return PropertyJsonParser.parseProperty((String)((String)this.redisStringCommands.get((Object)key)));
    }

    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        this.redisSetCommands.srem((Object)this.keyBuilder.getKeyPropertyMap(), (Object[])new String[]{name});
        this.redisKeyCommands.del((Object[])new String[]{this.keyBuilder.getKeyProperty(name)});
    }

    public Set<String> listPropertyNames() {
        return this.redisSetCommands.smembers((Object)this.keyBuilder.getKeyPropertyMap());
    }

    public Map<String, Property<?>> readAllProperties() {
        LinkedHashMap mapP = new LinkedHashMap();
        Set<String> properties = this.listPropertyNames();
        if (properties != null) {
            for (String key : properties) {
                mapP.put(key, this.readProperty(key));
            }
        }
        return mapP;
    }

    public void clear() {
        Set<String> myKeys = this.listPropertyNames();
        for (String key : myKeys) {
            this.deleteProperty(key);
        }
    }
}

