/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.redis.RedisConnection;
import org.ff4j.redis.RedisKeysBuilder;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.PropertyJsonParser;
import redis.clients.jedis.Jedis;

public class PropertyStoreRedis
extends AbstractPropertyStore {
    private RedisConnection redisConnection;
    private RedisKeysBuilder keyBuilder = new RedisKeysBuilder();

    public PropertyStoreRedis() {
        this(new RedisConnection(), new RedisKeysBuilder());
    }

    public PropertyStoreRedis(RedisKeysBuilder builder) {
        this(new RedisConnection(), builder);
    }

    public PropertyStoreRedis(RedisConnection pRedisConnection) {
        this(pRedisConnection, new RedisKeysBuilder());
    }

    public PropertyStoreRedis(RedisConnection pRedisConnection, RedisKeysBuilder builder) {
        this.redisConnection = pRedisConnection;
        this.keyBuilder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean existProperty(String name) {
        Util.assertParamHasLength((String)name, (String)"PropertyName identifier");
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            boolean bl = jedis.exists(this.keyBuilder.getKeyProperty(name));
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void createProperty(Property<T> prop) {
        Util.assertNotNull((Object[])new Object[]{prop});
        if (this.existProperty(prop.getName())) {
            throw new PropertyAlreadyExistException(prop.getName());
        }
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            String name = prop.getName();
            jedis.sadd(this.keyBuilder.getKeyPropertyMap(), new String[]{name});
            jedis.set(this.keyBuilder.getKeyProperty(name), prop.toJson());
            jedis.persist(this.keyBuilder.getKeyProperty(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property<?> readProperty(String name) {
        this.assertPropertyExist(name);
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Property property = PropertyJsonParser.parseProperty((String)jedis.get(this.keyBuilder.getKeyProperty(name)));
            return property;
        }
    }

    public void deleteProperty(String name) {
        this.assertPropertyExist(name);
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            jedis.srem(this.keyBuilder.getKeyPropertyMap(), new String[]{name});
            jedis.del(this.keyBuilder.getKeyProperty(name));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Property<?>> readAllProperties() {
        LinkedHashMap mapP = new LinkedHashMap();
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set properties = jedis.smembers(this.keyBuilder.getKeyPropertyMap());
            if (properties != null) {
                for (String key : properties) {
                    mapP.put(key, this.readProperty(key));
                }
            }
            LinkedHashMap<String, Property<?>> linkedHashMap = mapP;
            return linkedHashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listPropertyNames() {
        try (Jedis jedis = null;){
            Set propertyNames;
            jedis = this.getJedis();
            Set set = propertyNames = jedis.smembers(this.keyBuilder.getKeyPropertyMap());
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try (Jedis jedis = null;){
            jedis = this.getJedis();
            Set myKeys = jedis.smembers(this.keyBuilder.getKeyPropertyMap());
            for (String key : myKeys) {
                this.deleteProperty(key);
            }
        }
    }

    public RedisConnection getRedisConnection() {
        return this.redisConnection;
    }

    public void setRedisConnection(RedisConnection redisConnection) {
        this.redisConnection = redisConnection;
    }

    public Jedis getJedis() {
        if (this.redisConnection == null) {
            throw new IllegalArgumentException("Cannot found any redisConnection");
        }
        Jedis jedis = this.redisConnection.getJedis();
        if (jedis == null) {
            throw new IllegalArgumentException("Cannot found any jedis connection, please build connection");
        }
        return jedis;
    }
}

