/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.redis.clientsidecache;

import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.GetExArgs;
import io.lettuce.core.KeyValue;
import io.lettuce.core.SetArgs;
import io.lettuce.core.StrAlgoArgs;
import io.lettuce.core.StringMatchResult;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import io.lettuce.core.output.KeyValueStreamingChannel;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.ff4j.redis.clientsidecache.RedisClientSideCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientSideCacheRedisStringCommands<K, V>
implements RedisStringCommands<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final RedisStringCommands<K, V> delegate;
    private final RedisKeyCommands<K, V> redisKeyCommands;
    private final RedisClientSideCache<K, V> clientSideCache;

    public ClientSideCacheRedisStringCommands(RedisStringCommands<K, V> delegate, RedisKeyCommands<K, V> redisKeyCommands, RedisClientSideCache<K, V> clientSideCache) {
        this.delegate = delegate;
        this.redisKeyCommands = redisKeyCommands;
        this.clientSideCache = clientSideCache;
    }

    public Long append(K key, V value) {
        LOGGER.warn("append is not currently supported by client side caching");
        return this.delegate.append(key, value);
    }

    public Long bitcount(K key) {
        LOGGER.warn("bitcount is not currently supported by client side caching");
        return this.delegate.bitcount(key);
    }

    public Long bitcount(K key, long start, long end) {
        LOGGER.warn("bitcount is not currently supported by client side caching");
        return this.delegate.bitcount(key, start, end);
    }

    public List<Long> bitfield(K key, BitFieldArgs bitFieldArgs) {
        LOGGER.warn("bitfield is not currently supported by client side caching");
        return this.delegate.bitfield(key, bitFieldArgs);
    }

    public Long bitpos(K key, boolean state) {
        LOGGER.warn("bitpos is not currently supported by client side caching");
        return this.delegate.bitpos(key, state);
    }

    public Long bitpos(K key, boolean state, long start) {
        LOGGER.warn("bitpos is not currently supported by client side caching");
        return this.delegate.bitpos(key, state, start);
    }

    public Long bitpos(K key, boolean state, long start, long end) {
        LOGGER.warn("bitpos is not currently supported by client side caching");
        return this.delegate.bitpos(key, state, start, end);
    }

    public Long bitopAnd(K destination, K ... keys) {
        LOGGER.warn("bitopAnd is not currently supported by client side caching");
        return this.delegate.bitopAnd(destination, (Object[])keys);
    }

    public Long bitopNot(K destination, K source) {
        LOGGER.warn("bitopNot is not currently supported by client side caching");
        return this.delegate.bitopNot(destination, source);
    }

    public Long bitopOr(K destination, K ... keys) {
        LOGGER.warn("bitopOr is not currently supported by client side caching");
        return this.delegate.bitopOr(destination, (Object[])keys);
    }

    public Long bitopXor(K destination, K ... keys) {
        LOGGER.warn("bitopXor is not currently supported by client side caching");
        return this.delegate.bitopXor(destination, (Object[])keys);
    }

    public Long decr(K key) {
        LOGGER.warn("decr is not currently supported by client side caching");
        return this.delegate.decr(key);
    }

    public Long decrby(K key, long amount) {
        LOGGER.warn("decrby is not currently supported by client side caching");
        return this.delegate.decrby(key, amount);
    }

    public V get(K key) {
        long ttl;
        Object value = this.clientSideCache.get(key);
        if (value == null && (value = this.delegate.get(key)) != null && (ttl = this.redisKeyCommands.ttl(key).longValue()) >= 0L) {
            this.clientSideCache.put(key, value, ttl);
        }
        return value;
    }

    public Long getbit(K key, long offset) {
        LOGGER.warn("getbit is not currently supported by client side caching");
        return this.delegate.getbit(key, offset);
    }

    public V getdel(K key) {
        LOGGER.warn("getdel is not currently supported by client side caching");
        return (V)this.delegate.getdel(key);
    }

    public V getex(K key, GetExArgs args) {
        LOGGER.warn("getex is not currently supported by client side caching");
        return (V)this.delegate.getex(key, args);
    }

    public V getrange(K key, long start, long end) {
        LOGGER.warn("getrange is not currently supported by client side caching");
        return (V)this.delegate.getrange(key, start, end);
    }

    public V getset(K key, V value) {
        LOGGER.warn("getset is not currently supported by client side caching");
        return (V)this.delegate.getset(key, value);
    }

    public Long incr(K key) {
        LOGGER.warn("incr is not currently supported by client side caching");
        return this.delegate.incr(key);
    }

    public Long incrby(K key, long amount) {
        LOGGER.warn("incrby is not currently supported by client side caching");
        return this.delegate.incrby(key, amount);
    }

    public Double incrbyfloat(K key, double amount) {
        LOGGER.warn("incrbyfloat is not currently supported by client side caching");
        return this.delegate.incrbyfloat(key, amount);
    }

    public List<KeyValue<K, V>> mget(K ... keys) {
        LOGGER.warn("mget is not currently supported by client side caching");
        return this.delegate.mget((Object[])keys);
    }

    public Long mget(KeyValueStreamingChannel<K, V> channel, K ... keys) {
        LOGGER.warn("mget is not currently supported by client side caching");
        return this.delegate.mget(channel, (Object[])keys);
    }

    public String mset(Map<K, V> map) {
        LOGGER.warn("mset is not currently supported by client side caching");
        return this.delegate.mset(map);
    }

    public Boolean msetnx(Map<K, V> map) {
        LOGGER.warn("msetnx is not currently supported by client side caching");
        return this.delegate.msetnx(map);
    }

    public String set(K key, V value) {
        return this.delegate.set(key, value);
    }

    public String set(K key, V value, SetArgs setArgs) {
        LOGGER.warn("set is not currently supported by client side caching");
        return this.delegate.set(key, value, setArgs);
    }

    public V setGet(K key, V value) {
        LOGGER.warn("setGet is not currently supported by client side caching");
        return (V)this.delegate.setGet(key, value);
    }

    public V setGet(K key, V value, SetArgs setArgs) {
        LOGGER.warn("setGet is not currently supported by client side caching");
        return (V)this.delegate.setGet(key, value, setArgs);
    }

    public Long setbit(K key, long offset, int value) {
        LOGGER.warn("setbit is not currently supported by client side caching");
        return this.delegate.setbit(key, offset, value);
    }

    public String setex(K key, long seconds, V value) {
        LOGGER.warn("setex is not currently supported by client side caching");
        return this.delegate.setex(key, seconds, value);
    }

    public String psetex(K key, long milliseconds, V value) {
        LOGGER.warn("psetex is not currently supported by client side caching");
        return this.delegate.psetex(key, milliseconds, value);
    }

    public Boolean setnx(K key, V value) {
        LOGGER.warn("setnx is not currently supported by client side caching");
        return this.delegate.setnx(key, value);
    }

    public Long setrange(K key, long offset, V value) {
        LOGGER.warn("setrange is not currently supported by client side caching");
        return this.delegate.setrange(key, offset, value);
    }

    public StringMatchResult stralgoLcs(StrAlgoArgs strAlgoArgs) {
        LOGGER.warn("stralgoLcs is not currently supported by client side caching");
        return this.delegate.stralgoLcs(strAlgoArgs);
    }

    public Long strlen(K key) {
        LOGGER.warn("strlen is not currently supported by client side caching");
        return this.delegate.strlen(key);
    }
}

