/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.RedisClient;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisKeyCommands;
import io.lettuce.core.api.sync.RedisStringCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;
import org.ff4j.redis.RedisKeysBuilder;
import org.ff4j.redis.clientsidecache.ClientSideCacheRedisKeyCommands;
import org.ff4j.redis.clientsidecache.ClientSideCacheRedisStringCommands;
import org.ff4j.redis.clientsidecache.RedisClientSideCache;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;
import org.ff4j.utils.json.PropertyJsonParser;

public class FF4jCacheManagerRedisLettuce
implements FF4JCacheManager {
    protected int timeToLive = 900000000;
    private final Object nativeCache;
    private final RedisKeyCommands<String, String> redisKeyCommands;
    private final RedisStringCommands<String, String> redisStringCommands;
    private final RedisKeysBuilder keyBuilder;

    public FF4jCacheManagerRedisLettuce(RedisClient redisClient) {
        this(redisClient, new RedisKeysBuilder(), false);
    }

    public FF4jCacheManagerRedisLettuce(RedisClient redisClient, RedisKeysBuilder keyBuilder) {
        this(redisClient, keyBuilder, false);
    }

    public FF4jCacheManagerRedisLettuce(RedisClient redisClient, RedisKeysBuilder keyBuilder, boolean enableClientSideCache) {
        StatefulRedisConnection redisConnection = redisClient.connect();
        Object redisKeyCommands = redisConnection.sync();
        Object redisStringCommands = redisConnection.sync();
        this.nativeCache = redisConnection.sync();
        this.keyBuilder = keyBuilder;
        if (enableClientSideCache) {
            RedisClientSideCache clientSideCache = new RedisClientSideCache(redisConnection);
            redisStringCommands = new ClientSideCacheRedisStringCommands(redisStringCommands, redisKeyCommands, clientSideCache);
            redisKeyCommands = new ClientSideCacheRedisKeyCommands(redisKeyCommands, clientSideCache);
        }
        this.redisKeyCommands = redisKeyCommands;
        this.redisStringCommands = redisStringCommands;
    }

    public FF4jCacheManagerRedisLettuce(RedisClusterClient redisClusterClient) {
        this(redisClusterClient, new RedisKeysBuilder());
    }

    public FF4jCacheManagerRedisLettuce(RedisClusterClient redisClusterClient, RedisKeysBuilder keyBuilder) {
        StatefulRedisClusterConnection redisClusterConnection = redisClusterClient.connect();
        this.nativeCache = redisClusterConnection.sync();
        this.redisKeyCommands = redisClusterConnection.sync();
        this.redisStringCommands = redisClusterConnection.sync();
        this.keyBuilder = keyBuilder;
    }

    public Set<String> listCachedFeatureNames() {
        return this.getKeys(this.keyBuilder.getKeyFeature("*"));
    }

    public String getCacheProviderName() {
        return "REDIS";
    }

    public void clearFeatures() {
        try {
            Set<String> matchingKeys = this.getKeys(this.keyBuilder.getKeyFeature("*"));
            if (!matchingKeys.isEmpty()) {
                this.redisKeyCommands.del((Object[])matchingKeys.toArray(new String[matchingKeys.size()]));
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void clearProperties() {
        try {
            Set<String> matchingKeys = this.getKeys(this.keyBuilder.getKeyProperty("*"));
            if (!matchingKeys.isEmpty()) {
                this.redisKeyCommands.del((Object[])matchingKeys.toArray(new String[matchingKeys.size()]));
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void evictFeature(String uid) {
        Util.assertParamHasLength((String)uid, (String)" feature identifier");
        try {
            this.redisKeyCommands.del((Object[])new String[]{this.keyBuilder.getKeyFeature(uid)});
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void evictProperty(String propertyName) {
        Util.assertParamHasLength((String)propertyName, (String)" property name");
        try {
            if (propertyName == null || propertyName.isEmpty()) {
                throw new IllegalArgumentException("PropertyName cannot be null nor empty");
            }
            this.redisKeyCommands.del((Object[])new String[]{this.keyBuilder.getKeyProperty(propertyName)});
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void putFeature(Feature fp) {
        Util.assertNotNull((Object[])new Object[]{fp});
        try {
            this.redisStringCommands.set((Object)this.keyBuilder.getKeyFeature(fp.getUid()), (Object)fp.toJson());
            this.redisKeyCommands.expire((Object)this.keyBuilder.getKeyFeature(fp.getUid()), (long)this.getTimeToLive());
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void putProperty(Property<?> property) {
        Util.assertNotNull((Object[])new Object[]{property});
        try {
            this.redisStringCommands.set((Object)this.keyBuilder.getKeyProperty(property.getName()), (Object)property.toJson());
            this.redisKeyCommands.expire((Object)this.keyBuilder.getKeyProperty(property.getName()), (long)this.getTimeToLive());
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public Feature getFeature(String uid) {
        Util.assertParamHasLength((String)uid, (String)"feature uid");
        String value = "";
        try {
            value = (String)this.redisStringCommands.get((Object)this.keyBuilder.getKeyFeature(uid));
            if (value != null) {
                return FeatureJsonParser.parseFeature((String)value);
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
        return null;
    }

    public Property<?> getProperty(String propertyName) {
        Util.assertParamHasLength((String)propertyName, (String)"property name");
        String value = "";
        try {
            value = (String)this.redisStringCommands.get((Object)this.keyBuilder.getKeyProperty(propertyName));
            if (value != null) {
                return PropertyJsonParser.parseProperty((String)value);
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
        return null;
    }

    public Set<String> listCachedPropertyNames() {
        List keys = new ArrayList();
        try {
            keys = this.redisKeyCommands.keys((Object)this.keyBuilder.getKeyProperty("*"));
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
        return new HashSet<String>(keys);
    }

    public Object getFeatureNativeCache() {
        return this.nativeCache;
    }

    public Object getPropertyNativeCache() {
        return this.nativeCache;
    }

    private Set<String> getKeys(String pattern) {
        try {
            KeyScanCursor ksc = this.redisKeyCommands.scan(new ScanArgs().match(pattern));
            HashSet<String> matchingKeys = new HashSet<String>(ksc.getKeys());
            while (!ksc.isFinished()) {
                ksc = this.redisKeyCommands.scan((ScanCursor)ksc);
                matchingKeys.addAll(ksc.getKeys());
            }
            return matchingKeys;
        }
        catch (RuntimeException re) {
            this.onException(re);
            return null;
        }
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public RedisKeysBuilder getKeyBuilder() {
        return this.keyBuilder;
    }
}

