/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.cache;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.RedisClient;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ff4j.cache.FF4JCacheManager;
import org.ff4j.core.Feature;
import org.ff4j.property.Property;
import org.ff4j.redis.RedisKeysBuilder;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;
import org.ff4j.utils.json.PropertyJsonParser;

public class FF4jCacheManagerRedisLettuce
implements FF4JCacheManager {
    protected int timeToLive = 900000000;
    private RedisCommands<String, String> redisCommands;
    private RedisAdvancedClusterCommands<String, String> redisCommandsCluster;
    private RedisKeysBuilder keyBuilder = new RedisKeysBuilder();

    public FF4jCacheManagerRedisLettuce(RedisClient redisClient) {
        this(redisClient, new RedisKeysBuilder());
    }

    public FF4jCacheManagerRedisLettuce(RedisClient redisClient, RedisKeysBuilder keyBuilder) {
        this.redisCommands = redisClient.connect().sync();
        this.keyBuilder = keyBuilder;
    }

    public FF4jCacheManagerRedisLettuce(RedisClusterClient redisClusterClient) {
        this(redisClusterClient, new RedisKeysBuilder());
    }

    public FF4jCacheManagerRedisLettuce(RedisClusterClient redisClusterClient, RedisKeysBuilder keyBuilder) {
        this.redisCommandsCluster = redisClusterClient.connect().sync();
        this.keyBuilder = keyBuilder;
    }

    public Set<String> listCachedFeatureNames() {
        return this.getKeys(this.keyBuilder.getKeyFeature("*"));
    }

    public String getCacheProviderName() {
        return "REDIS";
    }

    public void clearFeatures() {
        try {
            Set<String> matchingKeys = this.getKeys(this.keyBuilder.getKeyFeature("*"));
            if (!matchingKeys.isEmpty()) {
                if (null != this.redisCommands) {
                    this.redisCommands.del((Object[])matchingKeys.toArray(new String[matchingKeys.size()]));
                } else {
                    this.redisCommandsCluster.del((Object[])matchingKeys.toArray(new String[matchingKeys.size()]));
                }
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void clearProperties() {
        try {
            Set<String> matchingKeys = this.getKeys(this.keyBuilder.getKeyProperty("*"));
            if (!matchingKeys.isEmpty()) {
                if (null != this.redisCommands) {
                    this.redisCommands.del((Object[])matchingKeys.toArray(new String[matchingKeys.size()]));
                } else {
                    this.redisCommandsCluster.del((Object[])matchingKeys.toArray(new String[matchingKeys.size()]));
                }
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void evictFeature(String uid) {
        Util.assertParamHasLength((String)uid, (String)" feature identifier");
        try {
            if (null != this.redisCommands) {
                this.redisCommands.del((Object[])new String[]{this.keyBuilder.getKeyFeature(uid)});
            } else {
                this.redisCommandsCluster.del((Object[])new String[]{this.keyBuilder.getKeyFeature(uid)});
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void evictProperty(String propertyName) {
        Util.assertParamHasLength((String)propertyName, (String)" property name");
        try {
            if (propertyName == null || propertyName.isEmpty()) {
                throw new IllegalArgumentException("PropertyName cannot be null nor empty");
            }
            if (null != this.redisCommands) {
                this.redisCommands.del((Object[])new String[]{this.keyBuilder.getKeyProperty(propertyName)});
            } else {
                this.redisCommandsCluster.del((Object[])new String[]{this.keyBuilder.getKeyProperty(propertyName)});
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void putFeature(Feature fp) {
        Util.assertNotNull((Object[])new Object[]{fp});
        try {
            if (null != this.redisCommands) {
                this.redisCommands.set((Object)this.keyBuilder.getKeyFeature(fp.getUid()), (Object)fp.toJson());
                this.redisCommands.expire((Object)this.keyBuilder.getKeyFeature(fp.getUid()), (long)this.getTimeToLive());
            } else {
                this.redisCommandsCluster.set((Object)this.keyBuilder.getKeyFeature(fp.getUid()), (Object)fp.toJson());
                this.redisCommandsCluster.expire((Object)this.keyBuilder.getKeyFeature(fp.getUid()), (long)this.getTimeToLive());
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public void putProperty(Property<?> property) {
        Util.assertNotNull((Object[])new Object[]{property});
        try {
            if (null != this.redisCommands) {
                this.redisCommands.set((Object)this.keyBuilder.getKeyProperty(property.getName()), (Object)property.toJson());
                this.redisCommands.expire((Object)this.keyBuilder.getKeyProperty(property.getName()), (long)this.getTimeToLive());
            } else {
                this.redisCommandsCluster.set((Object)this.keyBuilder.getKeyProperty(property.getName()), (Object)property.toJson());
                this.redisCommandsCluster.expire((Object)this.keyBuilder.getKeyProperty(property.getName()), (long)this.getTimeToLive());
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
    }

    public Feature getFeature(String uid) {
        Util.assertParamHasLength((String)uid, (String)"feature uid");
        String value = "";
        try {
            value = null != this.redisCommands ? (String)this.redisCommands.get((Object)this.keyBuilder.getKeyFeature(uid)) : (String)this.redisCommandsCluster.get((Object)this.keyBuilder.getKeyFeature(uid));
            if (value != null) {
                return FeatureJsonParser.parseFeature((String)value);
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
        return null;
    }

    public Property<?> getProperty(String propertyName) {
        Util.assertParamHasLength((String)propertyName, (String)"property name");
        String value = "";
        try {
            value = null != this.redisCommands ? (String)this.redisCommands.get((Object)this.keyBuilder.getKeyProperty(propertyName)) : (String)this.redisCommandsCluster.get((Object)this.keyBuilder.getKeyProperty(propertyName));
            if (value != null) {
                return PropertyJsonParser.parseProperty((String)value);
            }
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
        return null;
    }

    public Set<String> listCachedPropertyNames() {
        List keys = new ArrayList();
        try {
            keys = null != this.redisCommands ? this.redisCommands.keys((Object)this.keyBuilder.getKeyProperty("*")) : this.redisCommandsCluster.keys((Object)this.keyBuilder.getKeyProperty("*"));
        }
        catch (RuntimeException re) {
            this.onException(re);
        }
        return new HashSet<String>(keys);
    }

    public Object getFeatureNativeCache() {
        return null != this.redisCommands ? this.redisCommands : this.redisCommandsCluster;
    }

    public Object getPropertyNativeCache() {
        return null != this.redisCommands ? this.redisCommands : this.redisCommandsCluster;
    }

    private Set<String> getKeys(String pattern) {
        try {
            RedisCommands<String, String> redisKeyCommands = null != this.redisCommands ? this.redisCommands : this.redisCommandsCluster;
            KeyScanCursor ksc = redisKeyCommands.scan(new ScanArgs().match(pattern));
            HashSet<String> matchingKeys = new HashSet<String>(ksc.getKeys());
            while (!ksc.isFinished()) {
                ksc = redisKeyCommands.scan((ScanCursor)ksc);
                matchingKeys.addAll(ksc.getKeys());
            }
            return matchingKeys;
        }
        catch (RuntimeException re) {
            this.onException(re);
            return null;
        }
    }

    public int getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public RedisKeysBuilder getKeyBuilder() {
        return this.keyBuilder;
    }
}

