/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.sync.RedisAdvancedClusterCommands;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.redis.RedisKeysBuilder;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.utils.Util;
import org.ff4j.utils.json.FeatureJsonParser;

public class FeatureStoreRedisLettuce
extends AbstractFeatureStore {
    private RedisCommands<String, String> redisCommands;
    private RedisAdvancedClusterCommands<String, String> redisCommandsCluster;
    private RedisKeysBuilder keyBuilder = new RedisKeysBuilder();

    public FeatureStoreRedisLettuce(RedisClient redisClient) {
        this(redisClient, new RedisKeysBuilder());
    }

    public FeatureStoreRedisLettuce(RedisClient redisClient, RedisKeysBuilder keyBuilder) {
        this.redisCommands = redisClient.connect().sync();
        this.keyBuilder = keyBuilder;
    }

    public FeatureStoreRedisLettuce(RedisClusterClient redisClusterClient) {
        this(redisClusterClient, new RedisKeysBuilder());
    }

    public FeatureStoreRedisLettuce(RedisClusterClient redisClusterClient, RedisKeysBuilder keyBuilder) {
        this.redisCommandsCluster = redisClusterClient.connect().sync();
        this.keyBuilder = keyBuilder;
    }

    public boolean exist(String uid) {
        Util.assertParamHasLength((String)uid, (String)"Feature identifier");
        String key = this.keyBuilder.getKeyFeature(uid);
        return 1L == (null != this.redisCommands ? this.redisCommands.exists((Object[])new String[]{key}) : this.redisCommandsCluster.exists((Object[])new String[]{key}));
    }

    public Feature read(String uid) {
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        String key = this.keyBuilder.getKeyFeature(uid);
        return FeatureJsonParser.parseFeature((String)(null != this.redisCommands ? (String)this.redisCommands.get((Object)key) : (String)this.redisCommandsCluster.get((Object)key)));
    }

    public void update(Feature fp) {
        Util.assertNotNull((String)"Feature", (Object[])new Object[]{fp});
        if (!this.exist(fp.getUid())) {
            throw new FeatureNotFoundException(fp.getUid());
        }
        String key = this.keyBuilder.getKeyFeature(fp.getUid());
        if (null != this.redisCommands) {
            this.redisCommands.set((Object)key, (Object)fp.toJson());
            this.redisCommands.persist((Object)key);
        } else {
            this.redisCommandsCluster.set((Object)key, (Object)fp.toJson());
            this.redisCommandsCluster.persist((Object)key);
        }
    }

    public void enable(String uid) {
        Feature f = this.read(uid);
        f.enable();
        this.update(f);
    }

    public void disable(String uid) {
        Feature f = this.read(uid);
        f.disable();
        this.update(f);
    }

    public void create(Feature fp) {
        Util.assertNotNull((String)"Feature", (Object[])new Object[]{fp});
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        if (null != this.redisCommands) {
            this.redisCommands.sadd((Object)this.keyBuilder.getKeyFeatureMap(), (Object[])new String[]{fp.getUid()});
            this.redisCommands.set((Object)this.keyBuilder.getKeyFeature(fp.getUid()), (Object)fp.toJson());
            this.redisCommands.persist((Object)fp.getUid());
        } else {
            this.redisCommandsCluster.sadd((Object)this.keyBuilder.getKeyFeatureMap(), (Object[])new String[]{fp.getUid()});
            this.redisCommandsCluster.set((Object)this.keyBuilder.getKeyFeature(fp.getUid()), (Object)fp.toJson());
            this.redisCommandsCluster.persist((Object)fp.getUid());
        }
    }

    public Map<String, Feature> readAll() {
        Set features = null != this.redisCommands ? this.redisCommands.smembers((Object)this.keyBuilder.getKeyFeatureMap()) : this.redisCommandsCluster.smembers((Object)this.keyBuilder.getKeyFeatureMap());
        HashMap<String, Feature> featuresMap = new HashMap<String, Feature>();
        if (features != null) {
            for (String key : features) {
                featuresMap.put(key, this.read(key));
            }
        }
        return featuresMap;
    }

    public void delete(String fpId) {
        if (!this.exist(fpId)) {
            throw new FeatureNotFoundException(fpId);
        }
        if (null != this.redisCommands) {
            this.redisCommands.srem((Object)this.keyBuilder.getKeyFeatureMap(), (Object[])new String[]{fpId});
            this.redisCommands.del((Object[])new String[]{this.keyBuilder.getKeyFeature(fpId)});
        } else {
            this.redisCommandsCluster.srem((Object)this.keyBuilder.getKeyFeatureMap(), (Object[])new String[]{fpId});
            this.redisCommandsCluster.del((Object[])new String[]{this.keyBuilder.getKeyFeature(fpId)});
        }
    }

    public void grantRoleOnFeature(String flipId, String roleName) {
        Util.assertParamHasLength((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().add(roleName);
        this.update(f);
    }

    public void removeRoleFromFeature(String flipId, String roleName) {
        Util.assertParamHasLength((String)roleName, (String)"roleName (#2)");
        Feature f = this.read(flipId);
        f.getPermissions().remove(roleName);
        this.update(f);
    }

    public Map<String, Feature> readGroup(String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        if (group.isEmpty()) {
            throw new GroupNotFoundException(groupName);
        }
        return group;
    }

    public boolean existGroup(String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName");
        Map<String, Feature> features = this.readAll();
        HashMap<String, Feature> group = new HashMap<String, Feature>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            if (!groupName.equals(uid.getValue().getGroup())) continue;
            group.put(uid.getKey(), uid.getValue());
        }
        return !group.isEmpty();
    }

    public void enableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().enable();
            this.update(uid.getValue());
        }
    }

    public void disableGroup(String groupName) {
        Map<String, Feature> features = this.readGroup(groupName);
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            uid.getValue().disable();
            this.update(uid.getValue());
        }
    }

    public void addToGroup(String featureId, String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName (#2)");
        Feature f = this.read(featureId);
        f.setGroup(groupName);
        this.update(f);
    }

    public void removeFromGroup(String featureId, String groupName) {
        Util.assertParamHasLength((String)groupName, (String)"groupName (#2)");
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Feature f = this.read(featureId);
        f.setGroup(null);
        this.update(f);
    }

    public Set<String> readAllGroups() {
        Map<String, Feature> features = this.readAll();
        HashSet<String> groups = new HashSet<String>();
        for (Map.Entry<String, Feature> uid : features.entrySet()) {
            groups.add(uid.getValue().getGroup());
        }
        groups.remove(null);
        return groups;
    }

    public void clear() {
        Set myKeys = null != this.redisCommands ? this.redisCommands.smembers((Object)this.keyBuilder.getKeyFeatureMap()) : this.redisCommandsCluster.smembers((Object)this.keyBuilder.getKeyFeatureMap());
        for (String key : myKeys) {
            this.delete(key);
        }
    }
}

