/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.dynamodb.property;

import java.util.Map;
import java.util.Set;
import org.ff4j.dynamodb.property.PropertyDynamoDBClient;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

public class PropertyStoreDynamoDB
extends AbstractPropertyStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyStoreDynamoDB.class);
    private PropertyDynamoDBClient dynamoDBClient;

    public PropertyStoreDynamoDB() {
        this((DynamoDbClient)((DynamoDbClientBuilder)DynamoDbClient.builder().httpClientBuilder((SdkHttpClient.Builder)UrlConnectionHttpClient.builder())).build());
    }

    public PropertyStoreDynamoDB(DynamoDbClient client) {
        this.initStore(client);
    }

    public boolean existProperty(String name) {
        try {
            this.getClient().getItem(name);
        }
        catch (PropertyNotFoundException e) {
            return false;
        }
        return true;
    }

    public <T> void createProperty(Property<T> property) {
        Util.assertNotNull((Object[])new Object[]{property});
        Util.assertHasLength((String[])new String[]{property.getName()});
        if (this.existProperty(property.getName())) {
            throw new PropertyAlreadyExistException(property.getName());
        }
        this.getClient().put(property);
    }

    public void updateProperty(String name, String newValue) {
        Util.assertHasLength((String[])new String[]{name});
        Property<?> property = this.readProperty(name);
        property.setValueFromString(newValue);
        this.getClient().updateProperty(name, newValue);
    }

    public Property<?> readProperty(String name) {
        return this.getClient().get(name);
    }

    public void deleteProperty(String name) {
        Util.assertHasLength((String[])new String[]{name});
        if (!this.existProperty(name)) {
            throw new PropertyNotFoundException(name);
        }
        this.getClient().deleteItem(name);
    }

    public Map<String, Property<?>> readAllProperties() {
        return this.getClient().getAll();
    }

    public Set<String> listPropertyNames() {
        return this.getClient().getAllNames();
    }

    public void clear() {
        this.getClient().deleteTable();
        this.createSchema();
    }

    public void createSchema() {
        if (!this.getClient().tableExists()) {
            this.getClient().createTable();
        }
    }

    private void initStore(DynamoDbClient client) {
        this.dynamoDBClient = new PropertyDynamoDBClient(client);
        this.createSchema();
    }

    private PropertyDynamoDBClient getClient() {
        return this.dynamoDBClient;
    }
}

