/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.dynamodb.property;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.ff4j.dynamodb.DynamoDBClient;
import org.ff4j.dynamodb.property.DynamoDbProperty;
import org.ff4j.dynamodb.property.PropertyDynamoDBMapper;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.Property;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.enhanced.dynamodb.model.PageIterable;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;

class PropertyDynamoDBClient
extends DynamoDBClient<Property<?>, DynamoDbProperty> {
    private final PropertyDynamoDBMapper PROPERTY_MAPPER = new PropertyDynamoDBMapper();

    PropertyDynamoDBClient(DynamoDbClient client) {
        super(client);
        this.key = "name";
    }

    @Override
    protected RuntimeException notFoundException(String id) {
        return new PropertyNotFoundException(id);
    }

    @Override
    protected void put(Property<?> property) {
        this.table.putItem((Object)this.PROPERTY_MAPPER.toStore(property));
    }

    @Override
    protected Property<?> get(String name) {
        DynamoDbProperty item = (DynamoDbProperty)this.getItem(name);
        return this.PROPERTY_MAPPER.fromStore(item);
    }

    @Override
    protected Map<String, Property<?>> getAll() {
        PageIterable pages = this.table.scan();
        HashMap map = new HashMap();
        pages.items().forEach(dynamoDbProperty -> map.put(dynamoDbProperty.getName(), this.PROPERTY_MAPPER.fromStore((DynamoDbProperty)dynamoDbProperty)));
        return map;
    }

    void updateProperty(String propName, String newValue) {
        DynamoDbProperty item = (DynamoDbProperty)this.getItem(propName);
        if (item.getValue().equals(newValue)) {
            return;
        }
        item.setValue(newValue);
        this.table.updateItem((Object)item);
    }

    Set<String> getAllNames() {
        PageIterable pages = this.table.scan(builder -> builder.attributesToProject(new String[]{this.key}));
        HashSet<String> propNames = new HashSet<String>();
        pages.items().forEach(dynamoDbFeature -> propNames.add(dynamoDbFeature.getName()));
        return propNames;
    }

    @Override
    protected void loadProperties(Properties prop) {
        this.tableName = prop.getProperty("ff4j.store.dynamodb.property.table.name", "ff4j-properties");
        String billing = prop.getProperty("ff4j.store.dynamodb.property.table.billing", BillingMode.PROVISIONED.toString());
        this.billingMode = BillingMode.valueOf((String)billing);
        String rcu = prop.getProperty("ff4j.store.dynamodb.property.table.billing.rcu", String.valueOf(5L));
        this.billingRCU = Long.valueOf(rcu);
        String wcu = prop.getProperty("ff4j.store.dynamodb.property.table.billing.wcu", String.valueOf(5L));
        this.billingWCU = Long.valueOf(wcu);
    }

    @Override
    protected void createTable() {
        CreateTableRequest.Builder requestBuilder = CreateTableRequest.builder().attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("name").attributeType(ScalarAttributeType.S).build()}).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("name").keyType(KeyType.HASH).build()}).tableName(this.tableName);
        requestBuilder.billingMode(this.billingMode);
        if (BillingMode.PROVISIONED.equals((Object)this.billingMode)) {
            requestBuilder.provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(this.billingRCU).writeCapacityUnits(this.billingWCU).build());
        }
        try {
            this.client.createTable((CreateTableRequest)requestBuilder.build());
            this.client.waiter().waitUntilTableExists(builder -> builder.tableName(this.tableName));
            this.table = this.dynamoDB.table(this.tableName, TableSchema.fromClass(DynamoDbProperty.class));
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot initialize Property Table in DynamoDB", e);
        }
    }
}

