/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.dynamodb;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.Properties;
import org.ff4j.utils.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbEnhancedClient;
import software.amazon.awssdk.enhanced.dynamodb.DynamoDbTable;
import software.amazon.awssdk.enhanced.dynamodb.Key;
import software.amazon.awssdk.enhanced.dynamodb.TableSchema;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.BillingMode;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;

public abstract class DynamoDBClient<FF4J, STORE> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamoDBClient.class);
    protected final DynamoDbEnhancedClient dynamoDB;
    protected final DynamoDbClient client;
    private final Class<STORE> persistentClass;
    protected DynamoDbTable<STORE> table;
    protected String tableName;
    protected String key;
    protected BillingMode billingMode = BillingMode.PROVISIONED;
    protected Long billingRCU = 5L;
    protected Long billingWCU = 5L;

    public DynamoDBClient(DynamoDbClient client) {
        this.client = client;
        this.dynamoDB = DynamoDbEnhancedClient.builder().dynamoDbClient(client).build();
        this.loadPropertiesIfExist();
        this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.table = this.dynamoDB.table(this.tableName, TableSchema.fromClass(this.persistentClass));
    }

    public DynamoDBClient(DynamoDbClient client, Properties props, String tableName) {
        this.client = client;
        this.dynamoDB = DynamoDbEnhancedClient.builder().dynamoDbClient(client).build();
        this.persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[1];
        this.loadProperties(props);
        if (tableName != null) {
            this.tableName = tableName;
        }
        this.table = this.dynamoDB.table(tableName, TableSchema.fromClass(this.persistentClass));
    }

    protected abstract void createTable();

    protected abstract RuntimeException notFoundException(String var1);

    protected abstract FF4J get(String var1);

    protected abstract void put(FF4J var1);

    protected abstract Map<String, FF4J> getAll();

    protected abstract void loadProperties(Properties var1);

    public STORE getItem(String id) {
        Util.assertHasLength((String[])new String[]{id});
        Key key = Key.builder().partitionValue(id).build();
        Object item = this.table.getItem(r -> r.key(key));
        if (item == null) {
            throw this.notFoundException(id);
        }
        return (STORE)item;
    }

    public void deleteItem(String id) {
        this.table.deleteItem(Key.builder().partitionValue(id).build());
    }

    private void loadPropertiesIfExist() {
        Properties prop;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("ff4j-dynamodb.properties");
        if (in != null) {
            prop = new Properties();
            try {
                prop.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            throw new RuntimeException("ff4j-dynamodb.properties was not found in the classpath to setup the DynamoDB store");
        }
        this.loadProperties(prop);
    }

    public boolean tableExists() {
        try {
            this.client.describeTable(builder -> builder.tableName(this.tableName).build());
            this.table = this.dynamoDB.table(this.tableName, TableSchema.fromClass(this.persistentClass));
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    public void deleteTable() {
        this.client.deleteTable(builder -> builder.tableName(this.tableName).build());
        this.client.waiter().waitUntilTableNotExists(builder -> builder.tableName(this.tableName));
    }
}

